package com.usercentrics.sdk.v2.settings.data

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
data class UsercentricsLabels(
    // Required
    val btnAcceptAll: String,
    val btnDeny: String,
    val btnSave: String,
    val firstLayerTitle: String,
    val accepted: String,
    val denied: String,
    val date: String,
    val decision: String,
    val dataCollectedList: String,
    val dataCollectedInfo: String,
    val locationOfProcessing: String,
    val transferToThirdCountries: String,
    val transferToThirdCountriesInfo: String,
    val dataPurposes: String,
    val dataPurposesInfo: String,
    val dataRecipientsList: String,
    val descriptionOfService: String,
    val history: String,
    val historyDescription: String,
    val legalBasisList: String,
    val legalBasisInfo: String,
    val processingCompanyTitle: String,
    val retentionPeriod: String,
    val technologiesUsed: String,
    val technologiesUsedInfo: String,
    val cookiePolicyInfo: String,
    val optOut: String,
    val policyOf: String,
    val imprintLinkText: String,
    val privacyPolicyLinkText: String,
    val categories: String,
    val anyDomain: String,
    val day: String,
    val days: String,
    val domain: String,
    val duration: String,
    val informationLoadingNotPossible: String,
    val hour: String,
    val hours: String,
    val identifier: String,
    val maximumAgeCookieStorage: String,
    val minute: String,
    val minutes: String,
    val month: String,
    val months: String,
    val multipleDomains: String,
    val no: String,
    val nonCookieStorage: String,
    val seconds: String,
    val session: String,
    val loadingStorageInformation: String,
    val storageInformation: String,
    val detailedStorageInformation: String,
    val tryAgain: String,
    val type: String,
    val year: String,
    val years: String,
    val yes: String,
    val storageInformationDescription: String,
    // TODO MSDK-1081 - Why should not we use this? Do we have any alternative?
    val btnBannerReadMore: String,
    val readLess: String,
    val btnMore: String,
    val more: String,
    val linkToDpaInfo: String,
    val second: String,
    val consent: String,
    val headerModal: String,
    @SerialName("titleCorner")
    val secondLayerDescriptionHtml: String,
    @SerialName("headerCorner")
    val secondLayerTitle: String? = null,

    // Optional
    val settings: String? = null,
    val subConsents: String? = null,
    val btnAccept: String? = null,
    val poweredBy: String? = null,
    val dataProtectionOfficer: String? = null,
    val nameOfProcessingCompany: String? = null,
    val btnBack: String? = null,

    @Deprecated("This will be deprecated soon, please use the copyLabel field instead")
    val copy: String? = null,

    val copied: String? = null,
    val basic: String? = null,
    val advanced: String? = null,
    val processingCompany: String? = null,
    val name: String? = null,
    val explicit: String? = null,
    val implicit: String? = null,
    val btnMoreInfo: String? = null,
    val furtherInformationOptOut: String,
    val cookiePolicyLinkText: String,
    val noImplicit: String,
    val yesImplicit: String,

    internal val addressOfProcessingCompany: String? = null,
    internal val consentType: String? = null,
    internal val consents: String? = null,
    internal val language: String? = null,

    // legalGrounds
    internal val less: String? = null,
    internal val notAvailable: String? = null,
    internal val technology: String? = null,
    internal val view: String? = null,
) {

    // This field aims to replace the copy, since for iOS in RN, this is a reserved keyword
    val copyLabel = copy
}
