package com.usercentrics.sdk.v2.settings.data

import com.usercentrics.sdk.models.api.StringOrListSerializer
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.Transient

/** A Usercentrics DPS service. */
@Serializable
data class UsercentricsService(
    /** The template ID of the service. */
    val templateId: String? = null,
    /** The version of the service. */
    val version: String? = null,
    val type: String? = null,
    val adminSettingsId: List<String>? = null,
    val dataProcessor: String? = "",
    val dataPurposes: List<String> = listOf(),
    val processingCompany: String? = null,
    val nameOfProcessingCompany: String = "",
    val addressOfProcessingCompany: String = "",
    val descriptionOfService: String = "",
    @Serializable(StringOrListSerializer::class) val technologyUsed: List<String> = listOf(),
    val languagesAvailable: List<String> = listOf(),
    @Serializable(StringOrListSerializer::class) val dataCollectedList: List<String> = listOf(),
    @Serializable(StringOrListSerializer::class) val dataPurposesList: List<String> = listOf(),
    @Serializable(StringOrListSerializer::class) val dataRecipientsList: List<String> = listOf(),
    val legalBasisList: List<String> = listOf(),
    val retentionPeriodList: List<String> = listOf(),
    val subConsents: List<String>? = null,
    val language: String = "",
    val createdBy: String? = null,
    val updatedBy: String? = null,
    val isLatest: Boolean? = null,
    val linkToDpa: String = "",
    val legalGround: String = "",
    val optOutUrl: String = "",
    val policyOfProcessorUrl: String = "",
    /** The category slug identifier of the service. */
    @SerialName("defaultCategorySlug") val categorySlug: String? = null,
    val recordsOfProcessingActivities: String? = null,
    val retentionPeriodDescription: String = "",
    val dataProtectionOfficer: String = "",
    val privacyPolicyURL: String = "",
    val cookiePolicyURL: String = "",
    val locationOfProcessing: String = "",
    val dataCollectedDescription: String? = null,
    val thirdCountryTransfer: String = "",
    val description: String? = null,
    val cookieMaxAgeSeconds: Long? = null,
    val usesNonCookieAccess: Boolean? = null,
    val deviceStorageDisclosureUrl: String? = null,
    val deviceStorage: ConsentDisclosureObject = ConsentDisclosureObject(),
    val dpsDisplayFormat: String? = null,
    val isHidden: Boolean = false,
    val framework: String? = null,

    @Transient
    val isDeactivated: Boolean? = null,
    @Transient
    val isAutoUpdateAllowed: Boolean? = null,
    @Transient
    val disableLegalBasis: Boolean? = null,
    @Transient
    val isEssential: Boolean = false
)
