package com.usercentrics.sdk.v2.settings.data

import com.usercentrics.sdk.models.settings.USAFrameworks
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/** The general settings defined for the settingsId. */
@Serializable
data class UsercentricsSettings(
    // Required
    val labels: UsercentricsLabels,
    val secondLayer: SecondLayer,

    // Optional
    val version: String = "1.0.0",
    val language: String = "en",
    val imprintUrl: String? = null,
    val privacyPolicyUrl: String? = null,
    val cookiePolicyUrl: String? = null,
    @SerialName("bannerMessage")
    val firstLayerDescriptionHtml: String? = null,
    @SerialName("bannerMobileDescription")
    val firstLayerMobileDescriptionHtml: String? = null,
    val settingsId: String = "",
    val bannerMobileDescriptionIsActive: Boolean = false,
    val enablePoweredBy: Boolean = true,
    val displayOnlyForEU: Boolean = false,
    val tcf2Enabled: Boolean = false,
    val reshowBanner: Int? = 0,
    val editableLanguages: List<String> = listOf("en"),
    val languagesAvailable: List<String> = listOf("en"),
    val showInitialViewForVersionChange: List<String> = listOf(),
    val ccpa: CCPASettings? = null,
    val tcf2: TCF2Settings? = null,
    val customization: UsercentricsCustomization? = null,
    val firstLayer: FirstLayer? = null,
    val styles: UsercentricsStyles? = null,
    val interactionAnalytics: Boolean = false,
    val consentAnalytics: Boolean = defaultConsentAnalytics,
    val consentXDevice: Boolean = defaultXdevice,
    val variants: VariantsSettings? = null,
    val dpsDisplayFormat: DpsDisplayFormat? = null,
    val framework: USAFrameworks? = null,
    val publishedApps: List<PublishedApp>? = null,
    val renewConsentsTimestamp: Long? = null, // timestamp in seconds that represent the time when the manual resurface was requested
    val consentWebhook: Boolean = false,

    internal val consentTemplates: List<ServiceConsentTemplate> = listOf(),
    internal val categories: List<UsercentricsCategory>? = null,
) {

    companion object {
        internal const val defaultConsentAnalytics = false
        internal const val defaultXdevice = false
    }
}
