package com.usercentrics.sdk.v2.settings.repository

import com.usercentrics.sdk.core.application.INetworkStrategy
import com.usercentrics.sdk.core.json.JsonParser
import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.services.api.NewServiceTemplates
import com.usercentrics.sdk.services.tcf.Constants
import com.usercentrics.sdk.v2.etag.cache.EtagCacheStorage
import com.usercentrics.sdk.v2.etag.cache.IEtagCacheStorage
import com.usercentrics.sdk.v2.network.NetworkOrchestrator
import com.usercentrics.sdk.v2.settings.api.IAggregatorApi
import com.usercentrics.sdk.v2.settings.data.BasicConsentTemplate
import com.usercentrics.sdk.v2.settings.data.UsercentricsService

internal class AggregatorRepository(
    private val api: IAggregatorApi,
    private val json: JsonParser,
    logger: UsercentricsLogger,
    etagCacheStorage: IEtagCacheStorage,
    networkStrategy: INetworkStrategy
) : NetworkOrchestrator(logger, etagCacheStorage, networkStrategy), IAggregatorRepository {

    private var currentLanguage: String = Constants.FALLBACK_LANGUAGE

    override suspend fun fetchServices(
        language: String,
        services: List<BasicConsentTemplate>,
        bypassCache: Boolean
    ): List<UsercentricsService> {
        currentLanguage = language

        val response = resolveHttpBody2(bypassCache) { api.getServices(language, services, getApiHeaders()) }
        val serviceTemplates = parseJson(response)
        return serviceTemplates.templates
    }

    override fun etagKey(): String {
        return "${EtagCacheStorage.aggregatorDir}$currentLanguage"
    }

    private fun parseJson(responseBody: String): NewServiceTemplates = json.decodeFromString(responseBody)
}
