package com.usercentrics.sdk.v2.settings.repository

import com.usercentrics.sdk.core.application.INetworkStrategy
import com.usercentrics.sdk.core.json.JsonParser
import com.usercentrics.sdk.core.settings.SettingsInitializationParameters
import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.services.tcf.Constants
import com.usercentrics.sdk.v2.etag.cache.EtagCacheStorage
import com.usercentrics.sdk.v2.etag.cache.IEtagCacheStorage
import com.usercentrics.sdk.v2.network.NetworkOrchestrator
import com.usercentrics.sdk.v2.settings.api.ISettingsApi
import com.usercentrics.sdk.v2.settings.data.UsercentricsSettings

internal class SettingsRepository(
    private val api: ISettingsApi,
    private val jsonParser: JsonParser,
    logger: UsercentricsLogger,
    etagCacheStorage: IEtagCacheStorage,
    networkStrategy: INetworkStrategy
) : NetworkOrchestrator(logger, etagCacheStorage, networkStrategy), ISettingsRepository {

    private var currentLanguage: String = Constants.FALLBACK_LANGUAGE
    override var settingsEtagChanged: Boolean = false

    override suspend fun fetchSettings(
        settingsInitializationParameters: SettingsInitializationParameters
    ): UsercentricsSettings {
        currentLanguage = settingsInitializationParameters.jsonFileLanguage
        val bypassCache = settingsInitializationParameters.languageEtagChanged
        val settingsId = settingsInitializationParameters.settingsId
        val jsonFileVersion = settingsInitializationParameters.jsonFileVersion

        val response = resolveHttp2(bypassCache) { api.getSettings(settingsId, jsonFileVersion, currentLanguage, getApiHeaders()) }
        settingsEtagChanged = if (bypassCache) {
            true
        } else {
            shouldLoadFromApi(response.statusCode)
        }

        val jsonParsed = parseJson(response.body)
        return jsonParsed
    }

    override fun etagKey(): String {
        return "${EtagCacheStorage.settingsDir}$currentLanguage"
    }

    private fun parseJson(responseBody: String): UsercentricsSettings = jsonParser.decodeFromString(responseBody)
}
