package com.usercentrics.sdk.v2.tcf.facade

import com.usercentrics.sdk.errors.UsercentricsException
import com.usercentrics.sdk.models.api.ApiErrors
import com.usercentrics.sdk.v2.tcf.service.ITCFService
import com.usercentrics.tcf.core.model.gvl.Declarations
import com.usercentrics.tcf.core.model.gvl.VendorList

internal class TCFFacadeImpl(
    private val tcfService: ITCFService
) : TCFFacade {

    override suspend fun getVendorList(): Result<VendorList> {
        return try {
            tcfService.loadVendorList()
            Result.success(tcfService.vendorList!!)
        } catch (ex: Exception) {
            Result.failure(UsercentricsException(ApiErrors.FETCH_TCF_DATA, ex))
        }
    }

    override suspend fun getDeclarations(language: String): Result<Declarations> {
        return try {
            tcfService.loadDeclarations(language)
            Result.success(tcfService.declarations!!)
        } catch (ex: Exception) {
            Result.failure(UsercentricsException(ApiErrors.FETCH_TCF_DATA, ex))
        }
    }
}
