package com.usercentrics.sdk.v2.translation.repository

import com.usercentrics.sdk.core.application.INetworkStrategy
import com.usercentrics.sdk.core.json.JsonParser
import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.services.tcf.Constants
import com.usercentrics.sdk.v2.etag.cache.EtagCacheStorage
import com.usercentrics.sdk.v2.etag.cache.IEtagCacheStorage
import com.usercentrics.sdk.v2.network.NetworkOrchestrator
import com.usercentrics.sdk.v2.translation.api.ITranslationApi
import com.usercentrics.sdk.v2.translation.data.LegalBasisLocalization

internal class TranslationRepository(
    private val api: ITranslationApi,
    private val jsonParser: JsonParser,
    logger: UsercentricsLogger,
    etagCacheStorage: IEtagCacheStorage,
    networkStrategy: INetworkStrategy
) : NetworkOrchestrator(logger, etagCacheStorage, networkStrategy), ITranslationRepository {

    private var currentLanguage: String = Constants.FALLBACK_LANGUAGE

    override suspend fun fetchTranslations(language: String, bypassCache: Boolean): LegalBasisLocalization {
        currentLanguage = language

        val response = resolveHttpBody2(bypassCache) { api.getTranslations(language, getApiHeaders()) }
        return parseJson(response)
    }

    override fun etagKey(): String {
        return "${EtagCacheStorage.translationsDir}$currentLanguage"
    }

    private fun parseJson(responseBody: String): LegalBasisLocalization = jsonParser.decodeFromString(responseBody)
}
