package com.usercentrics.tcf.core.encoder

@Suppress("EnumEntryName")
internal enum class BitLength(val integer: Int) {

    cmpId(12),
    cmpVersion(12),
    consentLanguage(12),
    consentScreen(6),
    created(36),
    isServiceSpecific(1),
    lastUpdated(36),
    policyVersion(6),
    publisherCountryCode(12),
    publisherLegitimateInterests(24),
    publisherConsents(24),
    purposeConsents(24),
    purposeLegitimateInterests(24),
    purposeOneTreatment(1),
    specialFeatureOptins(12),
    useNonStandardStacks(1),
    vendorListVersion(12),
    version(6),
    anyBoolean(1),
    encodingType(1),
    maxId(16),
    numCustomPurposes(6),
    numEntries(12),
    numRestrictions(12),
    purposeId(6),
    restrictionType(2),
    segmentType(3),
    singleOrRange(1),
    vendorId(16);

    companion object {
        fun getByName(name: String): BitLength? {
            return when (name) {
                "cmpId" -> cmpId
                "cmpVersion" -> cmpVersion
                "consentLanguage" -> consentLanguage
                "consentScreen" -> consentScreen
                "created" -> created
                "isServiceSpecific" -> isServiceSpecific
                "lastUpdated" -> lastUpdated
                "policyVersion" -> policyVersion
                "publisherCountryCode" -> publisherCountryCode
                "publisherLegitimateInterests" -> publisherLegitimateInterests
                "publisherConsents" -> publisherConsents
                "purposeConsents" -> purposeConsents
                "purposeLegitimateInterests" -> purposeLegitimateInterests
                "purposeOneTreatment" -> purposeOneTreatment
                "specialFeatureOptins" -> specialFeatureOptins
                "useNonStandardStacks" -> useNonStandardStacks
                "vendorListVersion" -> vendorListVersion
                "version" -> version
                "anyBoolean" -> anyBoolean
                "encodingType" -> encodingType
                "maxId" -> maxId
                "numCustomPurposes" -> numCustomPurposes
                "numEntries" -> numEntries
                "numRestrictions" -> numRestrictions
                "purposeId" -> purposeId
                "restrictionType" -> restrictionType
                "segmentType" -> segmentType
                "singleOrRange" -> singleOrRange
                "vendorId" -> vendorId
                else -> null
            }
        }
    }
}
