package com.usercentrics.tcf.core.encoder.field

import com.usercentrics.tcf.core.StringOrNumber
import com.usercentrics.tcf.core.errors.DecodingError
import com.usercentrics.tcf.core.errors.EncodingError

internal class LangEncoder {

    companion object {

        fun encode(value: String, numBits: Int): String {

            val internalValue: String = value.uppercase()

            @Suppress("LocalVariableName") val ASCII_START = 65
            val firstLetter: Int = internalValue[0].code.toByte() - ASCII_START
            val secondLetter: Int = internalValue[1].code.toByte() - ASCII_START

            // check some things to throw some good errors
            if (firstLetter < 0 || firstLetter > 25 || secondLetter < 0 || secondLetter > 25) {
                throw EncodingError("Invalid Language Code: $internalValue")
            }

            if (numBits % 2 == 1) {
                throw EncodingError("numBits must be even, $numBits is not valid")
            }

            val singleCharacterNumBits = numBits / 2
            val firstLetterBString: String =
                IntEncoder.encode(StringOrNumber.Int(firstLetter), singleCharacterNumBits)
            val secondLetterBString: String =
                IntEncoder.encode(StringOrNumber.Int(secondLetter), singleCharacterNumBits)

            return firstLetterBString + secondLetterBString
        }

        fun decode(value: String, numBits: Int): String {

            val retr: String

            // is it an even number of bits? we have to divide it
            if (numBits == value.length && ((value.length % 2) == 0)) {

                @Suppress("LocalVariableName") val ASCII_START = 65
                val mid = value.length / 2
                val firstLetter = IntEncoder.decode(
                    value.slice(IntRange(0, mid - 1)),
                    mid
                ) + ASCII_START
                val secondLetter = IntEncoder.decode(
                    value.slice(IntRange(mid, value.length - 1)),
                    mid
                ) + ASCII_START


                retr = "${firstLetter.toInt().toChar()}${secondLetter.toInt().toChar()}"

            } else {
                throw DecodingError("Invalid bit length for language")
            }

            return retr
        }
    }
}
