package com.usercentrics.tcf.core.model

import com.usercentrics.tcf.core.errors.TCModelError

@Suppress("SpellCheckingInspection")
internal class PurposeRestriction {

    companion object {
        private const val hashSeparator: String = "-"

        fun unHash(hash: String): PurposeRestriction {
            val splitUp: List<String> = hash.split(this.hashSeparator)
            val purpRestriction = PurposeRestriction(null, null)

            if (splitUp.size != 2) {
                throw TCModelError("hash", hash)
            }

            purpRestriction.purposeId_ = splitUp[0].toInt()
            purpRestriction.restrictionType = RestrictionType.getRestrictionTypeByValue(splitUp[1].toInt())

            return purpRestriction
        }
    }

    @Suppress("PrivatePropertyName")
    private var purposeId_: Int? = null

    lateinit var restrictionType: RestrictionType

    /**
     * constructor
     *
     * @param {number} purposeId? - may optionally pass the purposeId into the
     * constructor
     * @param {RestrictionType} restrictionType? - may
     * optionally pass the restrictionType into the constructor
     * @return {undefined}
     */
    constructor(purposeId: Int?, restrictionType: RestrictionType?) {
        if (purposeId != null) {
            this.purposeId_ = purposeId
        }

        if (restrictionType != null) {
            this.restrictionType = restrictionType
        }
    }

    fun getHash(): String {
        if (!this.isValid()) {
            throw Throwable("cannot hash invalid PurposeRestriction")
        }

        return "${this.purposeId_}$hashSeparator${this.restrictionType.value}"
    }

    /**
     * @return {number} The purpose Id associated with a publisher
     * purpose-by-vendor restriction that resulted in a different consent or LI
     * status than the consent or LI purposes allowed lists.
     */
    fun getPurposeId(): Int? {
        return this.purposeId_
    }

    @Suppress("MemberVisibilityCanBePrivate")
    fun isValid(): Boolean {
        val isValid = this.restrictionType == RestrictionType.NOT_ALLOWED ||
                this.restrictionType == RestrictionType.REQUIRE_CONSENT ||
                this.restrictionType == RestrictionType.REQUIRE_LI

        return (this.purposeId_ is Int && this.purposeId_!! > 0 && isValid)
    }
}
