/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.mediation.sdk;

import android.content.Context;
import com.chartboost.sdk.Chartboost;
import com.chartboost.sdk.privacy.model.CCPA;
import com.chartboost.sdk.privacy.model.DataUseConsent;
import com.chartboost.sdk.privacy.model.GDPR;
import com.chartboost.sdk.privacy.model.LGPD;
import com.usercentrics.sdk.log.UsercentricsLogger;
import com.usercentrics.sdk.mediation.MediationSDK;
import com.usercentrics.sdk.models.common.UsercentricsVariant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001c\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00112\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u0002J\u001c\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00112\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u0002J\u001c\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00112\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u0002R\u0019\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/usercentrics/sdk/mediation/sdk/ChartboostMediationSDK;", "Lcom/usercentrics/sdk/mediation/MediationSDK;", "name", "", "logger", "Lcom/usercentrics/sdk/log/UsercentricsLogger;", "context", "Landroid/content/Context;", "Lcom/usercentrics/sdk/UsercentricsContext;", "(Ljava/lang/String;Lcom/usercentrics/sdk/log/UsercentricsLogger;Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "getLogger", "()Lcom/usercentrics/sdk/log/UsercentricsLogger;", "getName", "()Ljava/lang/String;", "apply", "", "consent", "variant", "Lcom/usercentrics/sdk/models/common/UsercentricsVariant;", "applyCCPAConsent", "", "applyGDPRConsent", "applyLGPDConsent", "usercentrics_release"})
public final class ChartboostMediationSDK
extends MediationSDK {
    @NotNull
    private final String name;
    @NotNull
    private final UsercentricsLogger logger;
    @Nullable
    private final Context context;

    public ChartboostMediationSDK(@NotNull String name, @NotNull UsercentricsLogger logger2, @Nullable Context context) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        super(name, logger2, null, 4, null);
        this.name = name;
        this.logger = logger2;
        this.context = context;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public UsercentricsLogger getLogger() {
        return this.logger;
    }

    @Nullable
    public final Context getContext() {
        return this.context;
    }

    @Override
    public boolean apply(boolean consent, @NotNull UsercentricsVariant variant) {
        Intrinsics.checkNotNullParameter((Object)((Object)variant), (String)"variant");
        try {
            Class.forName("com.chartboost.sdk.Chartboost");
            Context context = this.context;
            Intrinsics.checkNotNull((Object)context);
            Context context2 = context;
            if (variant == UsercentricsVariant.CCPA) {
                this.applyCCPAConsent(consent, context2);
            } else {
                this.applyGDPRConsent(consent, context2);
                this.applyLGPDConsent(consent, context2);
            }
            return true;
        }
        catch (Exception ex) {
            this.logException(ex);
            return false;
        }
    }

    private final void applyCCPAConsent(boolean consent, Context context) {
        CCPA.CCPA_CONSENT actualConsentValue = consent ? CCPA.CCPA_CONSENT.OPT_IN_SALE : CCPA.CCPA_CONSENT.OPT_OUT_SALE;
        Chartboost.addDataUseConsent((Context)context, (DataUseConsent)((DataUseConsent)new CCPA(actualConsentValue)));
    }

    private final void applyGDPRConsent(boolean consent, Context context) {
        GDPR.GDPR_CONSENT actualConsentValue = consent ? GDPR.GDPR_CONSENT.BEHAVIORAL : GDPR.GDPR_CONSENT.NON_BEHAVIORAL;
        Chartboost.addDataUseConsent((Context)context, (DataUseConsent)((DataUseConsent)new GDPR(actualConsentValue)));
    }

    private final void applyLGPDConsent(boolean consent, Context context) {
        Chartboost.addDataUseConsent((Context)context, (DataUseConsent)((DataUseConsent)new LGPD(consent)));
    }
}

