/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.mediation.sdk;

import com.google.firebase.analytics.FirebaseAnalytics;
import com.google.firebase.analytics.ktx.AnalyticsKt;
import com.google.firebase.ktx.Firebase;
import com.usercentrics.sdk.log.UsercentricsLogger;
import com.usercentrics.sdk.mediation.MediationSDK;
import com.usercentrics.sdk.mediation.data.MediationGranularConsent;
import com.usercentrics.sdk.models.common.UsercentricsVariant;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0010H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/usercentrics/sdk/mediation/sdk/FirebaseAnalyticsMediationSDK;", "Lcom/usercentrics/sdk/mediation/MediationSDK;", "name", "", "vendorId", "", "logger", "Lcom/usercentrics/sdk/log/UsercentricsLogger;", "(Ljava/lang/String;ILcom/usercentrics/sdk/log/UsercentricsLogger;)V", "getLogger", "()Lcom/usercentrics/sdk/log/UsercentricsLogger;", "getName", "()Ljava/lang/String;", "getVendorId", "()Ljava/lang/Integer;", "apply", "", "consent", "variant", "Lcom/usercentrics/sdk/models/common/UsercentricsVariant;", "applyGranular", "granularConsent", "Lcom/usercentrics/sdk/mediation/data/MediationGranularConsent;", "consentStatus", "Lcom/google/firebase/analytics/FirebaseAnalytics$ConsentStatus;", "usercentrics_release"})
public final class FirebaseAnalyticsMediationSDK
extends MediationSDK {
    @NotNull
    private final String name;
    private final int vendorId;
    @NotNull
    private final UsercentricsLogger logger;

    public FirebaseAnalyticsMediationSDK(@NotNull String name, int vendorId, @NotNull UsercentricsLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        super(name, logger2, null, 4, null);
        this.name = name;
        this.vendorId = vendorId;
        this.logger = logger2;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Integer getVendorId() {
        return this.vendorId;
    }

    @Override
    @NotNull
    public UsercentricsLogger getLogger() {
        return this.logger;
    }

    @Override
    public boolean apply(boolean consent, @NotNull UsercentricsVariant variant) {
        Intrinsics.checkNotNullParameter((Object)((Object)variant), (String)"variant");
        try {
            FirebaseAnalytics firebaseAnalytics;
            Class.forName("com.google.firebase.analytics.FirebaseAnalytics");
            FirebaseAnalytics $this$apply_u24lambda_u240 = firebaseAnalytics = AnalyticsKt.getAnalytics((Firebase)Firebase.INSTANCE);
            boolean bl = false;
            $this$apply_u24lambda_u240.setConsent(MapsKt.mapOf((Pair)TuplesKt.to((Object)FirebaseAnalytics.ConsentType.ANALYTICS_STORAGE, (Object)this.consentStatus(consent))));
            $this$apply_u24lambda_u240.setAnalyticsCollectionEnabled(consent);
            return true;
        }
        catch (Exception ex) {
            this.logException(ex);
            return false;
        }
    }

    @Override
    public boolean applyGranular(@NotNull MediationGranularConsent granularConsent) {
        Intrinsics.checkNotNullParameter((Object)granularConsent, (String)"granularConsent");
        try {
            Class.forName("com.google.firebase.analytics.FirebaseAnalytics");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)FirebaseAnalytics.ConsentType.AD_STORAGE, (Object)this.consentStatus(granularConsent.getAdStorage())), TuplesKt.to((Object)FirebaseAnalytics.ConsentType.AD_PERSONALIZATION, (Object)this.consentStatus(granularConsent.getAdPersonalization())), TuplesKt.to((Object)FirebaseAnalytics.ConsentType.AD_USER_DATA, (Object)this.consentStatus(granularConsent.getAdUserData())), TuplesKt.to((Object)FirebaseAnalytics.ConsentType.ANALYTICS_STORAGE, (Object)this.consentStatus(granularConsent.getAnalyticsStorage()))};
            AnalyticsKt.getAnalytics((Firebase)Firebase.INSTANCE).setConsent(MapsKt.mapOf((Pair[])pairArray));
            AnalyticsKt.getAnalytics((Firebase)Firebase.INSTANCE).setAnalyticsCollectionEnabled(granularConsent.getAnalyticsStorage());
            return true;
        }
        catch (Exception ex) {
            this.logException(ex);
            return false;
        }
    }

    private final FirebaseAnalytics.ConsentStatus consentStatus(boolean consent) {
        return consent ? FirebaseAnalytics.ConsentStatus.GRANTED : FirebaseAnalytics.ConsentStatus.DENIED;
    }
}

