/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.services.api;

import com.usercentrics.sdk.BuildKonfig;
import com.usercentrics.sdk.UsercentricsDomains;
import com.usercentrics.sdk.models.common.NetworkMode;
import com.usercentrics.sdk.services.api.NetworkResolver;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/usercentrics/sdk/services/api/MainNetworkResolver;", "Lcom/usercentrics/sdk/services/api/NetworkResolver;", "networkMode", "Lcom/usercentrics/sdk/models/common/NetworkMode;", "domains", "Lcom/usercentrics/sdk/UsercentricsDomains;", "(Lcom/usercentrics/sdk/models/common/NetworkMode;Lcom/usercentrics/sdk/UsercentricsDomains;)V", "aggregatorBaseUrl", "", "analyticsBaseUrl", "billingBaseUrl", "cdnBaseUrl", "getConsentsBaseUrl", "isSelfHostedEnabled", "", "saveConsentsBaseUrl", "usercentrics_release"})
public final class MainNetworkResolver
implements NetworkResolver {
    @NotNull
    private final NetworkMode networkMode;
    @NotNull
    private final UsercentricsDomains domains;

    public MainNetworkResolver(@NotNull NetworkMode networkMode, @NotNull UsercentricsDomains domains) {
        Intrinsics.checkNotNullParameter((Object)((Object)networkMode), (String)"networkMode");
        Intrinsics.checkNotNullParameter((Object)domains, (String)"domains");
        this.networkMode = networkMode;
        this.domains = domains;
    }

    @Override
    @NotNull
    public String aggregatorBaseUrl() {
        String string;
        if (this.isSelfHostedEnabled()) {
            return this.domains.getAggregatorCdnUrl();
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.networkMode.ordinal()]) {
            case 1: {
                string = BuildKonfig.INSTANCE.getEndpoint_aggregatorCdn();
                break;
            }
            case 2: {
                string = BuildKonfig.INSTANCE.getEndpoint_aggregatorCdnEu();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Override
    @NotNull
    public String billingBaseUrl() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.networkMode.ordinal()]) {
            case 1: {
                string = BuildKonfig.INSTANCE.getEndpoint_billing();
                break;
            }
            case 2: {
                string = BuildKonfig.INSTANCE.getEndpoint_billingEu();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Override
    @NotNull
    public String getConsentsBaseUrl() {
        String string;
        if (this.isSelfHostedEnabled()) {
            return this.domains.getGetConsentsUrl();
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.networkMode.ordinal()]) {
            case 1: {
                string = BuildKonfig.INSTANCE.getEndpoint_getConsents();
                break;
            }
            case 2: {
                string = BuildKonfig.INSTANCE.getEndpoint_getConsentsEu();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Override
    @NotNull
    public String saveConsentsBaseUrl() {
        String string;
        if (this.isSelfHostedEnabled()) {
            return this.domains.getSaveConsentsUrl();
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.networkMode.ordinal()]) {
            case 1: {
                string = BuildKonfig.INSTANCE.getEndpoint_saveConsents();
                break;
            }
            case 2: {
                string = BuildKonfig.INSTANCE.getEndpoint_saveConsentsEu();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Override
    @NotNull
    public String cdnBaseUrl() {
        String string;
        if (this.isSelfHostedEnabled()) {
            return this.domains.getCdnUrl();
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.networkMode.ordinal()]) {
            case 1: {
                string = BuildKonfig.INSTANCE.getEndpoint_cdn();
                break;
            }
            case 2: {
                string = BuildKonfig.INSTANCE.getEndpoint_cdnEu();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Override
    @NotNull
    public String analyticsBaseUrl() {
        String string;
        if (this.isSelfHostedEnabled()) {
            return this.domains.getAnalyticsUrl();
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.networkMode.ordinal()]) {
            case 1: {
                string = BuildKonfig.INSTANCE.getEndpoint_analytics();
                break;
            }
            case 2: {
                string = BuildKonfig.INSTANCE.getEndpoint_analyticsEu();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final boolean isSelfHostedEnabled() {
        return this.domains.isValid$usercentrics_release();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NetworkMode.values().length];
            try {
                nArray[NetworkMode.WORLD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NetworkMode.EU.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

