/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.services.deviceStorage;

import com.usercentrics.ccpa.CCPAStorage;
import com.usercentrics.sdk.AssertionsKt;
import com.usercentrics.sdk.core.json.JsonParser;
import com.usercentrics.sdk.core.json.JsonParserKt;
import com.usercentrics.sdk.log.UsercentricsLogger;
import com.usercentrics.sdk.models.common.UserSessionDataConsent;
import com.usercentrics.sdk.models.gdpr.DefaultUISettings;
import com.usercentrics.sdk.models.settings.LegacyConsentHistoryEntry;
import com.usercentrics.sdk.models.settings.LegacyExtendedSettings;
import com.usercentrics.sdk.models.settings.LegacyService;
import com.usercentrics.sdk.models.settings.PredefinedUILanguage;
import com.usercentrics.sdk.models.settings.PredefinedUILanguageSettings;
import com.usercentrics.sdk.models.settings.SettingsVersion;
import com.usercentrics.sdk.models.tcf.TCFUISettings;
import com.usercentrics.sdk.services.deviceStorage.DeviceStorage;
import com.usercentrics.sdk.services.deviceStorage.KeyValueStorage;
import com.usercentrics.sdk.services.deviceStorage.KeyValueStorageExtensionsKt;
import com.usercentrics.sdk.services.deviceStorage.StorageHolder;
import com.usercentrics.sdk.services.deviceStorage.StorageKeys;
import com.usercentrics.sdk.services.deviceStorage.migrations.Migration;
import com.usercentrics.sdk.services.deviceStorage.migrations.MigrationException;
import com.usercentrics.sdk.services.deviceStorage.migrations.MigrationNotFoundException;
import com.usercentrics.sdk.services.deviceStorage.migrations.MigrationToVersion1;
import com.usercentrics.sdk.services.deviceStorage.models.ConsentsBuffer;
import com.usercentrics.sdk.services.deviceStorage.models.StorageConsentHistory;
import com.usercentrics.sdk.services.deviceStorage.models.StorageService;
import com.usercentrics.sdk.services.deviceStorage.models.StorageSessionEntry;
import com.usercentrics.sdk.services.deviceStorage.models.StorageSettings;
import com.usercentrics.sdk.services.deviceStorage.models.StorageTCF;
import com.usercentrics.tcf.core.IABTCFKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001eB5\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001d\u001a\u00020\u0016H\u0016J\b\u0010\u001e\u001a\u00020\u0016H\u0002J\b\u0010\u001f\u001a\u00020\u0016H\u0002J\b\u0010 \u001a\u00020\u0016H\u0016J\b\u0010!\u001a\u00020\u0016H\u0016J\b\u0010\"\u001a\u00020\u0016H\u0002J\u0016\u0010#\u001a\u00020\u00162\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0%H\u0016J\b\u0010&\u001a\u00020\u001aH\u0016J\b\u0010'\u001a\u00020\u0011H\u0016J\n\u0010(\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010)\u001a\u00020\u001aH\u0016J\b\u0010*\u001a\u00020\u001aH\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\tH\u0016J\u000f\u0010-\u001a\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020\u001aH\u0016J\u000f\u00102\u001a\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010.J\b\u00103\u001a\u00020\u001aH\u0016J\b\u00104\u001a\u00020\u001aH\u0016J\b\u00105\u001a\u00020\u001aH\u0016J\b\u00106\u001a\u00020\u0007H\u0002J\b\u00107\u001a\u00020\u0013H\u0016J\b\u00108\u001a\u000209H\u0016J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020;0\tH\u0016J\b\u0010<\u001a\u000209H\u0002J\b\u0010=\u001a\u00020\u0016H\u0016J\u000f\u0010>\u001a\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010.J\u001c\u0010?\u001a\b\u0012\u0004\u0012\u00020@0\t2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\tH\u0002J\u001e\u0010C\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020D2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\tH\u0002J\u0018\u0010E\u001a\u00020\u00162\u0006\u0010F\u001a\u00020\u00072\u0006\u0010G\u001a\u00020\u0007H\u0002J\u000e\u0010H\u001a\b\u0012\u0004\u0012\u00020,0\tH\u0002J\b\u0010I\u001a\u00020\u0016H\u0002J\u0010\u0010J\u001a\u00020\u00162\u0006\u0010K\u001a\u00020\u001aH\u0016J\u0010\u0010L\u001a\u00020\u00162\u0006\u0010M\u001a\u00020\u001aH\u0016J\u0010\u0010N\u001a\u00020\u00162\u0006\u0010O\u001a\u00020\u001aH\u0016J\u001e\u0010P\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020D2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\tH\u0016J\b\u0010Q\u001a\u00020\u0016H\u0002J\u0010\u0010R\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010S\u001a\u00020\u00162\u0006\u0010T\u001a\u00020\u0018H\u0016J\u0010\u0010U\u001a\u00020\u00162\u0006\u0010V\u001a\u000200H\u0016J\u0010\u0010W\u001a\u00020\u00162\u0006\u0010X\u001a\u00020\u0018H\u0016J\u0010\u0010Y\u001a\u0002092\u0006\u0010Z\u001a\u00020\u0007H\u0002J\u0010\u0010[\u001a\u0002092\u0006\u0010\\\u001a\u00020DH\u0002J\u001c\u0010]\u001a\u00020\u00162\u0012\u0010^\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020`0_H\u0016J\b\u0010a\u001a\u00020bH\u0016J\u0016\u0010c\u001a\u00020\u00162\f\u0010d\u001a\b\u0012\u0004\u0012\u00020,0%H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006f"}, d2={"Lcom/usercentrics/sdk/services/deviceStorage/UsercentricsDeviceStorage;", "Lcom/usercentrics/sdk/services/deviceStorage/DeviceStorage;", "storageHolder", "Lcom/usercentrics/sdk/services/deviceStorage/StorageHolder;", "logger", "Lcom/usercentrics/sdk/log/UsercentricsLogger;", "currentVersion", "", "migrations", "", "Lcom/usercentrics/sdk/services/deviceStorage/migrations/Migration;", "jsonParser", "Lcom/usercentrics/sdk/core/json/JsonParser;", "(Lcom/usercentrics/sdk/services/deviceStorage/StorageHolder;Lcom/usercentrics/sdk/log/UsercentricsLogger;ILjava/util/List;Lcom/usercentrics/sdk/core/json/JsonParser;)V", "defaultStorage", "Lcom/usercentrics/sdk/services/deviceStorage/KeyValueStorage;", "settings", "Lcom/usercentrics/sdk/services/deviceStorage/models/StorageSettings;", "tcfData", "Lcom/usercentrics/sdk/services/deviceStorage/models/StorageTCF;", "usercentricsStorage", "addSessionToBuffer", "", "currentTime", "", "settingsId", "", "bootSettings", "bootTCFData", "clear", "clearCCPAStorageEntries", "clearSessionBuffer", "clearTCFStorageEntries", "clearUserActionRequired", "clearUsercentricsStorageEntries", "deleteSettingsThatDoNotMatch", "settingsIds", "", "fetchCcpaString", "fetchSettings", "getABTestingVariant", "getACString", "getActualTCFSettingsId", "getAndEraseSessionBuffer", "Lcom/usercentrics/sdk/services/deviceStorage/models/StorageSessionEntry;", "getCcpaTimestampInMillis", "()Ljava/lang/Long;", "getConsentBuffer", "Lcom/usercentrics/sdk/services/deviceStorage/models/ConsentsBuffer;", "getControllerId", "getSessionTimestamp", "getSettingsId", "getSettingsLanguage", "getSettingsVersion", "getStorageVersion", "getTCFData", "getUserActionRequired", "", "getUserSessionDataConsents", "Lcom/usercentrics/sdk/models/common/UserSessionDataConsent;", "hasDataFromVersion0", "init", "lastInteractionTimestamp", "mapStorageServices", "Lcom/usercentrics/sdk/services/deviceStorage/models/StorageService;", "services", "Lcom/usercentrics/sdk/models/settings/LegacyService;", "mapStorageSettings", "Lcom/usercentrics/sdk/models/settings/LegacyExtendedSettings;", "migrateDataAfterVersionChange", "oldVersion", "targetVersion", "readSessionBuffer", "runMigrations", "saveABTestingVariant", "variant", "saveACString", "acString", "saveActualTCFSettingsId", "actualSettingsId", "saveSettings", "saveStorageCurrentVersion", "saveTCFData", "setCcpaTimestampInMillis", "timestampInMillis", "setConsentBuffer", "buffer", "setSessionTimestamp", "sessionTimestamp", "shouldMigrate", "storageVersion", "shouldReshowBannerAfterVersionChange", "currentSettings", "storeValuesDefaultStorage", "values", "", "", "toCcpaStorage", "Lcom/usercentrics/ccpa/CCPAStorage;", "writeSessionBuffer", "sessionBufferSet", "Builder", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nUsercentricsDeviceStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UsercentricsDeviceStorage.kt\ncom/usercentrics/sdk/services/deviceStorage/UsercentricsDeviceStorage\n+ 2 JsonParser.kt\ncom/usercentrics/sdk/core/json/JsonParser\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 6 Serializers.kt\nkotlinx/serialization/SerializersKt__SerializersKt\n+ 7 Platform.common.kt\nkotlinx/serialization/internal/Platform_commonKt\n*L\n1#1,409:1\n32#2:410\n40#2:415\n31#2,2:426\n40#2:428\n32#2:429\n40#2:430\n24#2:431\n36#2:435\n1855#3:411\n1855#3,2:412\n1856#3:414\n1549#3:418\n1620#3,2:419\n1549#3:421\n1620#3,3:422\n1622#3:425\n1855#3,2:439\n288#3,2:443\n1855#3,2:445\n13309#4,2:416\n12474#4,2:441\n123#5:432\n113#5:436\n32#6:433\n32#6:437\n80#7:434\n80#7:438\n*S KotlinDebug\n*F\n+ 1 UsercentricsDeviceStorage.kt\ncom/usercentrics/sdk/services/deviceStorage/UsercentricsDeviceStorage\n*L\n98#1:410\n156#1:415\n204#1:426,2\n211#1:428\n218#1:429\n230#1:430\n313#1:431\n321#1:435\n131#1:411\n132#1:412,2\n131#1:414\n191#1:418\n191#1:419,2\n193#1:421\n193#1:422,3\n191#1:425\n327#1:439,2\n362#1:443,2\n367#1:445,2\n165#1:416,2\n348#1:441,2\n313#1:432\n321#1:436\n313#1:433\n321#1:437\n313#1:434\n321#1:438\n*E\n"})
public final class UsercentricsDeviceStorage
implements DeviceStorage {
    @NotNull
    private final StorageHolder storageHolder;
    @NotNull
    private final UsercentricsLogger logger;
    private final int currentVersion;
    @NotNull
    private final List<Migration> migrations;
    @NotNull
    private final JsonParser jsonParser;
    @NotNull
    private final KeyValueStorage defaultStorage;
    @NotNull
    private final KeyValueStorage usercentricsStorage;
    @NotNull
    private StorageSettings settings;
    @NotNull
    private StorageTCF tcfData;

    private UsercentricsDeviceStorage(StorageHolder storageHolder, UsercentricsLogger logger2, int currentVersion, List<? extends Migration> migrations, JsonParser jsonParser) {
        this.storageHolder = storageHolder;
        this.logger = logger2;
        this.currentVersion = currentVersion;
        this.migrations = migrations;
        this.jsonParser = jsonParser;
        this.defaultStorage = this.storageHolder.getDefaultKeyValueStorage();
        this.usercentricsStorage = this.storageHolder.getUsercentricsKeyValueStorage();
        this.settings = new StorageSettings(null, null, null, null, null, 31, null);
        this.tcfData = new StorageTCF(null, null, null, 7, null);
    }

    @Override
    public void init() {
        this.runMigrations();
    }

    @Override
    public void clear() {
        UsercentricsLogger.DefaultImpls.debug$default(this.logger, "Clearing local storage", null, 2, null);
        this.clearUsercentricsStorageEntries();
        this.clearTCFStorageEntries();
        this.clearCCPAStorageEntries();
        this.settings = new StorageSettings(null, null, null, null, null, 31, null);
        this.tcfData = new StorageTCF(null, null, null, 7, null);
    }

    @Override
    @NotNull
    public String getActualTCFSettingsId() {
        String string = this.usercentricsStorage.getString(StorageKeys.ACTUAL_TCF_SETTINGS_ID.getText(), "");
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public void storeValuesDefaultStorage(@NotNull Map<String, ? extends Object> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.defaultStorage.putValuesMap(values);
    }

    @Override
    @NotNull
    public CCPAStorage toCcpaStorage() {
        return KeyValueStorageExtensionsKt.toCcpaStorage(this.defaultStorage);
    }

    @Override
    public void setCcpaTimestampInMillis(long timestampInMillis) {
        this.usercentricsStorage.put(StorageKeys.CCPA_TIMESTAMP.getText(), String.valueOf(timestampInMillis));
    }

    @Override
    @Nullable
    public Long getCcpaTimestampInMillis() {
        Long l;
        try {
            String string = this.usercentricsStorage.getString(StorageKeys.CCPA_TIMESTAMP.getText(), null);
            l = string != null ? Long.valueOf(Long.parseLong(string)) : null;
        }
        catch (Throwable e) {
            l = null;
        }
        return l;
    }

    @Override
    public void setSessionTimestamp(long sessionTimestamp) {
        this.usercentricsStorage.put(StorageKeys.SESSION_TIMESTAMP.getText(), String.valueOf(sessionTimestamp));
    }

    @Override
    @Nullable
    public Long getSessionTimestamp() {
        Long l;
        String timestamp = this.usercentricsStorage.getString(StorageKeys.SESSION_TIMESTAMP.getText(), null);
        try {
            String string = timestamp;
            l = string != null ? Long.valueOf(Long.parseLong(string)) : null;
        }
        catch (Throwable e) {
            l = null;
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void bootSettings(@NotNull String settingsId) {
        StorageSettings storageSettings;
        Intrinsics.checkNotNullParameter((Object)settingsId, (String)"settingsId");
        StorageSettings parsedSettings = null;
        String storageSettings2 = this.usercentricsStorage.getString(StorageKeys.SETTINGS_PATTERN.getText() + settingsId, null);
        Object object = storageSettings2;
        if (!(object == null || StringsKt.isBlank((CharSequence)object))) {
            void deserializer$iv;
            object = this.jsonParser;
            DeserializationStrategy deserializationStrategy = (DeserializationStrategy)StorageSettings.Companion.serializer();
            UsercentricsLogger logger$iv = this.logger;
            boolean $i$f$tryToDecodeFromString = false;
            parsedSettings = (StorageSettings)JsonParserKt.tryToDecodeFromString(JsonParserKt.access$getJson$p(), deserializer$iv, storageSettings2, logger$iv);
        }
        if ((storageSettings = parsedSettings) == null) {
            storageSettings = new StorageSettings(null, null, null, null, null, 31, null);
        }
        this.settings = storageSettings;
    }

    @Override
    @NotNull
    public StorageSettings fetchSettings() {
        return this.settings;
    }

    @Override
    @Nullable
    public Long lastInteractionTimestamp() {
        return this.fetchSettings().getLastInteractionTimestamp();
    }

    @Override
    @NotNull
    public String getSettingsVersion() {
        return this.fetchSettings().getVersion();
    }

    @Override
    @NotNull
    public String getSettingsId() {
        return this.fetchSettings().getId();
    }

    @Override
    @NotNull
    public String getControllerId() {
        return this.fetchSettings().getControllerId();
    }

    @Override
    @NotNull
    public String getSettingsLanguage() {
        return this.fetchSettings().getLanguage();
    }

    @Override
    @NotNull
    public List<UserSessionDataConsent> getUserSessionDataConsents() {
        List consentList = new ArrayList();
        StorageSettings settings = this.fetchSettings();
        Iterable $this$forEach$iv = settings.getServices();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StorageService service = (StorageService)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = service.getHistory();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                StorageConsentHistory history = (StorageConsentHistory)element$iv2;
                boolean bl2 = false;
                consentList.add(new UserSessionDataConsent(history.getStatus(), service.getId(), history.getTimestampInMillis()));
            }
        }
        return consentList;
    }

    @Override
    public void saveSettings(@NotNull LegacyExtendedSettings settings, @NotNull List<LegacyService> services) {
        StorageSettings storageSettings;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter(services, (String)"services");
        boolean versionChangeRequiresReshow = this.shouldReshowBannerAfterVersionChange(settings);
        if (versionChangeRequiresReshow) {
            this.usercentricsStorage.put(StorageKeys.USER_ACTION_REQUIRED.getText(), "true");
        }
        this.settings = storageSettings = this.mapStorageSettings(settings, services);
        JsonParser jsonParser = this.jsonParser;
        SerializationStrategy serializer$iv = (SerializationStrategy)StorageSettings.Companion.serializer();
        boolean $i$f$encodeToString = false;
        this.usercentricsStorage.put(StorageKeys.SETTINGS_PATTERN.getText() + settings.getId(), JsonParserKt.access$getJson$p().encodeToString(serializer$iv, (Object)storageSettings));
    }

    private final void clearUsercentricsStorageEntries() {
        this.usercentricsStorage.deleteAll(CollectionsKt.listOf((Object)StorageKeys.LOCATION_CACHE.getText()));
    }

    @Override
    public void clearTCFStorageEntries() {
        IABTCFKeys[] $this$forEach$iv = IABTCFKeys.values();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            IABTCFKeys element$iv;
            IABTCFKeys entry = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.defaultStorage.deleteKey(entry.getKey());
        }
        for (int i = 1; i < 12; ++i) {
            this.defaultStorage.deleteKey(IABTCFKeys.Companion.publisherRestrictionsKeyOf(i));
        }
    }

    private final StorageSettings mapStorageSettings(LegacyExtendedSettings settings, List<LegacyService> services) {
        PredefinedUILanguage predefinedUILanguage;
        if (settings.isTcfEnabled()) {
            Object object = settings.getTcfui();
            PredefinedUILanguage predefinedUILanguage2 = object != null && (object = ((TCFUISettings)object).getLanguage()) != null ? ((PredefinedUILanguageSettings)object).getSelected() : null;
            predefinedUILanguage = predefinedUILanguage2;
            Intrinsics.checkNotNull((Object)predefinedUILanguage2);
        } else {
            Object object = settings.getUi();
            PredefinedUILanguage predefinedUILanguage3 = object != null && (object = ((DefaultUISettings)object).getLanguage()) != null ? ((PredefinedUILanguageSettings)object).getSelected() : null;
            predefinedUILanguage = predefinedUILanguage3;
            Intrinsics.checkNotNull((Object)predefinedUILanguage3);
        }
        PredefinedUILanguage selectedLanguage = predefinedUILanguage;
        return new StorageSettings(settings.getControllerId(), settings.getId(), selectedLanguage.getIsoCode(), this.mapStorageServices(services), settings.getVersion());
    }

    /*
     * WARNING - void declaration
     */
    private final List<StorageService> mapStorageServices(List<LegacyService> services) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = services;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void service;
            LegacyService legacyService = (LegacyService)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = service.getConsent().getHistory();
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                LegacyConsentHistoryEntry legacyConsentHistoryEntry = (LegacyConsentHistoryEntry)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(StorageConsentHistory.Companion.fromConsentHistory((LegacyConsentHistoryEntry)it));
            }
            boolean bl3 = service.getConsent().getStatus();
            String string = service.getProcessorId();
            String string2 = service.getId();
            List list = (List)destination$iv$iv2;
            collection.add(new StorageService(list, string2, string, bl3));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public ConsentsBuffer getConsentBuffer() {
        AssertionsKt.assertNotUIThread();
        String string = this.usercentricsStorage.getString(StorageKeys.CONSENTS_BUFFER.getText(), null);
        if (string == null) {
            string = "";
        }
        String bufferString = string;
        JsonParser jsonParser = this.jsonParser;
        DeserializationStrategy deserializer$iv = (DeserializationStrategy)ConsentsBuffer.Companion.serializer();
        UsercentricsLogger logger$iv = null;
        boolean $i$f$tryToDecodeFromString = false;
        ConsentsBuffer consentsBuffer = (ConsentsBuffer)JsonParserKt.tryToDecodeFromString(JsonParserKt.access$getJson$p(), deserializer$iv, bufferString, logger$iv);
        if (consentsBuffer == null) {
            consentsBuffer = new ConsentsBuffer(CollectionsKt.emptyList());
        }
        return consentsBuffer;
    }

    @Override
    public void setConsentBuffer(@NotNull ConsentsBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        AssertionsKt.assertNotUIThread();
        JsonParser jsonParser = this.jsonParser;
        SerializationStrategy serializer$iv = (SerializationStrategy)ConsentsBuffer.Companion.serializer();
        boolean $i$f$encodeToString = false;
        this.usercentricsStorage.put(StorageKeys.CONSENTS_BUFFER.getText(), JsonParserKt.access$getJson$p().encodeToString(serializer$iv, (Object)buffer));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public StorageTCF bootTCFData(@NotNull String settingsId) {
        block2: {
            void deserializer$iv;
            String tcfData;
            Intrinsics.checkNotNullParameter((Object)settingsId, (String)"settingsId");
            String string = this.usercentricsStorage.getString(StorageKeys.TCF_PATTERN.getText() + settingsId, null);
            if (string == null) {
                string = "";
            }
            if (!(!StringsKt.isBlank((CharSequence)(tcfData = string)))) break block2;
            JsonParser jsonParser = this.jsonParser;
            DeserializationStrategy deserializationStrategy = (DeserializationStrategy)StorageTCF.Companion.serializer();
            UsercentricsLogger logger$iv = this.logger;
            boolean $i$f$tryToDecodeFromString = false;
            StorageTCF storageTCF = (StorageTCF)JsonParserKt.tryToDecodeFromString(JsonParserKt.access$getJson$p(), deserializer$iv, tcfData, logger$iv);
            if (storageTCF != null) {
                StorageTCF it = storageTCF;
                boolean bl = false;
                this.tcfData = it;
            }
        }
        return this.tcfData;
    }

    @Override
    public void saveTCFData(@NotNull StorageTCF tcfData) {
        Intrinsics.checkNotNullParameter((Object)tcfData, (String)"tcfData");
        this.tcfData = tcfData;
        String settingsId = this.settings.getId();
        JsonParser jsonParser = this.jsonParser;
        SerializationStrategy serializer$iv = (SerializationStrategy)StorageTCF.Companion.serializer();
        boolean $i$f$encodeToString = false;
        this.usercentricsStorage.put(StorageKeys.TCF_PATTERN.getText() + settingsId, JsonParserKt.access$getJson$p().encodeToString(serializer$iv, (Object)tcfData));
        this.saveActualTCFSettingsId(settingsId);
    }

    @Override
    public void saveActualTCFSettingsId(@NotNull String actualSettingsId) {
        Intrinsics.checkNotNullParameter((Object)actualSettingsId, (String)"actualSettingsId");
        this.usercentricsStorage.put(StorageKeys.ACTUAL_TCF_SETTINGS_ID.getText(), actualSettingsId);
    }

    @Override
    @NotNull
    public StorageTCF getTCFData() {
        return this.tcfData;
    }

    @Override
    @NotNull
    public String fetchCcpaString() {
        String string = this.defaultStorage.getString("IABUSPrivacy_String", null);
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public void addSessionToBuffer(long currentTime, @NotNull String settingsId) {
        Intrinsics.checkNotNullParameter((Object)settingsId, (String)"settingsId");
        Set sessionBufferSet = CollectionsKt.toMutableSet((Iterable)this.readSessionBuffer());
        sessionBufferSet.add(new StorageSessionEntry(settingsId, currentTime));
        this.writeSessionBuffer(sessionBufferSet);
    }

    @Override
    @NotNull
    public List<StorageSessionEntry> getAndEraseSessionBuffer() {
        List<StorageSessionEntry> sessionBuffer = this.readSessionBuffer();
        this.clearSessionBuffer();
        return sessionBuffer;
    }

    @Override
    public void saveABTestingVariant(@NotNull String variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        this.usercentricsStorage.put(StorageKeys.AB_TESTING_VARIANT.getText(), variant);
    }

    @Override
    @Nullable
    public String getABTestingVariant() {
        return this.usercentricsStorage.getString(StorageKeys.AB_TESTING_VARIANT.getText(), null);
    }

    @Override
    public boolean getUserActionRequired() {
        String userActionRequired;
        String string = userActionRequired = this.usercentricsStorage.getString(StorageKeys.USER_ACTION_REQUIRED.getText(), null);
        return string != null ? Boolean.parseBoolean(string) : false;
    }

    @Override
    public void clearUserActionRequired() {
        this.usercentricsStorage.deleteKey(StorageKeys.USER_ACTION_REQUIRED.getText());
    }

    @Override
    public void saveACString(@NotNull String acString) {
        Intrinsics.checkNotNullParameter((Object)acString, (String)"acString");
        this.defaultStorage.put(IABTCFKeys.ADDITIONAL_CONSENT_MODE.getKey(), acString);
    }

    @Override
    @NotNull
    public String getACString() {
        String string = this.defaultStorage.getString(IABTCFKeys.ADDITIONAL_CONSENT_MODE.getKey(), null);
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public void deleteSettingsThatDoNotMatch(@NotNull Set<String> settingsIds) {
        Intrinsics.checkNotNullParameter(settingsIds, (String)"settingsIds");
        this.usercentricsStorage.deleteKeysThatDoNotMatch(StorageKeys.TCF_PATTERN.getText(), settingsIds);
        this.usercentricsStorage.deleteKeysThatDoNotMatch(StorageKeys.SETTINGS_PATTERN.getText(), settingsIds);
    }

    private final boolean shouldReshowBannerAfterVersionChange(LegacyExtendedSettings currentSettings) {
        String storageVersion = this.settings.getVersion();
        if (StringsKt.isBlank((CharSequence)storageVersion)) {
            return false;
        }
        if (currentSettings.getShowFirstLayerOnVersionChange().isEmpty()) {
            return false;
        }
        char[] cArray = new char[]{'.'};
        List currentVersionArray = StringsKt.split$default((CharSequence)currentSettings.getVersion(), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        char[] cArray2 = new char[]{'.'};
        List storageVersionArray = StringsKt.split$default((CharSequence)storageVersion, (char[])cArray2, (boolean)false, (int)0, (int)6, null);
        return currentSettings.getShowFirstLayerOnVersionChange().contains(SettingsVersion.MAJOR.ordinal()) && !Intrinsics.areEqual(currentVersionArray.get(0), storageVersionArray.get(0)) || currentSettings.getShowFirstLayerOnVersionChange().contains(SettingsVersion.MINOR.ordinal()) && !Intrinsics.areEqual(currentVersionArray.get(1), storageVersionArray.get(1)) || currentSettings.getShowFirstLayerOnVersionChange().contains(SettingsVersion.PATCH.ordinal()) && !Intrinsics.areEqual(currentVersionArray.get(2), storageVersionArray.get(2));
    }

    private final List<StorageSessionEntry> readSessionBuffer() {
        AssertionsKt.assertNotUIThread();
        String jsonArray = this.usercentricsStorage.getString(StorageKeys.SESSION_BUFFER.getText(), null);
        CharSequence charSequence = jsonArray;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return CollectionsKt.emptyList();
        }
        JsonParser this_$iv = this.jsonParser;
        boolean $i$f$decodeFromString = false;
        StringFormat $this$decodeFromString$iv$iv = (StringFormat)JsonParserKt.access$getJson$p();
        boolean $i$f$decodeFromString2 = false;
        SerializersModule $this$serializer$iv$iv$iv = $this$decodeFromString$iv$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(StorageSessionEntry.class))));
        boolean $i$f$cast = false;
        Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
        return (List)$this$decodeFromString$iv$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv$iv, jsonArray);
    }

    private final void clearSessionBuffer() {
        this.writeSessionBuffer(SetsKt.emptySet());
    }

    private final void writeSessionBuffer(Set<StorageSessionEntry> sessionBufferSet) {
        String string = StorageKeys.SESSION_BUFFER.getText();
        JsonParser this_$iv = this.jsonParser;
        boolean $i$f$encodeToString = false;
        StringFormat $this$encodeToString$iv$iv = (StringFormat)JsonParserKt.access$getJson$p();
        boolean $i$f$encodeToString2 = false;
        SerializersModule $this$serializer$iv$iv$iv = $this$encodeToString$iv$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(Set.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(StorageSessionEntry.class))));
        boolean $i$f$cast = false;
        Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
        this.usercentricsStorage.put(string, $this$encodeToString$iv$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv$iv, sessionBufferSet));
    }

    private final void runMigrations() {
        int storageVersion = this.getStorageVersion();
        if (this.shouldMigrate(storageVersion)) {
            Iterable $this$forEach$iv = (Iterable)new IntRange(storageVersion + 1, this.currentVersion);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                int element$iv;
                int targetVersion = element$iv = ((IntIterator)iterator2).nextInt();
                boolean bl = false;
                int oldVersion = targetVersion - 1;
                try {
                    this.migrateDataAfterVersionChange(oldVersion, targetVersion);
                }
                catch (Throwable cause) {
                    throw new MigrationException("Cannot migrate stored data from " + oldVersion + " to " + targetVersion, cause);
                }
            }
        }
        this.saveStorageCurrentVersion();
    }

    private final boolean shouldMigrate(int storageVersion) {
        return storageVersion == 0 ? this.hasDataFromVersion0() : storageVersion < this.currentVersion;
    }

    private final boolean hasDataFromVersion0() {
        boolean bl;
        block1: {
            MigrationToVersion1.V0StorageKeys[] $this$any$iv = MigrationToVersion1.V0StorageKeys.values();
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                MigrationToVersion1.V0StorageKeys element$iv;
                MigrationToVersion1.V0StorageKeys key = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!this.storageHolder.getDefaultKeyValueStorage().hasKey(key.getText())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final int getStorageVersion() {
        return this.usercentricsStorage.getNumber(StorageKeys.STORAGE_VERSION.getText(), 0);
    }

    private final void migrateDataAfterVersionChange(int oldVersion, int targetVersion) {
        Object v0;
        block3: {
            Iterable $this$firstOrNull$iv = this.migrations;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Migration it = (Migration)element$iv;
                boolean bl = false;
                if (!(it.getFromVersion() == oldVersion && it.getToVersion() == targetVersion)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Migration hasExactMigration = v0;
        if (hasExactMigration == null) {
            throw new MigrationNotFoundException(oldVersion, targetVersion);
        }
        Iterable $this$forEach$iv = this.migrations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Migration migration = (Migration)element$iv;
            boolean bl = false;
            if (migration.getFromVersion() != oldVersion || migration.getToVersion() != targetVersion) continue;
            migration.migrate();
        }
    }

    private final void saveStorageCurrentVersion() {
        this.usercentricsStorage.put(StorageKeys.STORAGE_VERSION.getText(), this.currentVersion);
    }

    private final void clearCCPAStorageEntries() {
        this.defaultStorage.deleteKey("IABUSPrivacy_String");
    }

    public /* synthetic */ UsercentricsDeviceStorage(StorageHolder storageHolder, UsercentricsLogger logger2, int currentVersion, List migrations, JsonParser jsonParser, DefaultConstructorMarker $constructor_marker) {
        this(storageHolder, logger2, currentVersion, migrations, jsonParser);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001f\u0010\u000e\u001a\u00020\u00002\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0010\"\u00020\r\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/usercentrics/sdk/services/deviceStorage/UsercentricsDeviceStorage$Builder;", "", "storageHolder", "Lcom/usercentrics/sdk/services/deviceStorage/StorageHolder;", "logger", "Lcom/usercentrics/sdk/log/UsercentricsLogger;", "jsonParser", "Lcom/usercentrics/sdk/core/json/JsonParser;", "currentVersion", "", "(Lcom/usercentrics/sdk/services/deviceStorage/StorageHolder;Lcom/usercentrics/sdk/log/UsercentricsLogger;Lcom/usercentrics/sdk/core/json/JsonParser;I)V", "migrations", "", "Lcom/usercentrics/sdk/services/deviceStorage/migrations/Migration;", "addMigration", "migration", "", "([Lcom/usercentrics/sdk/services/deviceStorage/migrations/Migration;)Lcom/usercentrics/sdk/services/deviceStorage/UsercentricsDeviceStorage$Builder;", "build", "Lcom/usercentrics/sdk/services/deviceStorage/DeviceStorage;", "usercentrics_release"})
    public static final class Builder {
        @NotNull
        private final StorageHolder storageHolder;
        @NotNull
        private final UsercentricsLogger logger;
        @NotNull
        private final JsonParser jsonParser;
        private final int currentVersion;
        @NotNull
        private final List<Migration> migrations;

        public Builder(@NotNull StorageHolder storageHolder, @NotNull UsercentricsLogger logger2, @NotNull JsonParser jsonParser, int currentVersion) {
            Intrinsics.checkNotNullParameter((Object)storageHolder, (String)"storageHolder");
            Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)jsonParser, (String)"jsonParser");
            this.storageHolder = storageHolder;
            this.logger = logger2;
            this.jsonParser = jsonParser;
            this.currentVersion = currentVersion;
            this.migrations = new ArrayList();
        }

        public /* synthetic */ Builder(StorageHolder storageHolder, UsercentricsLogger usercentricsLogger, JsonParser jsonParser, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                n = 8;
            }
            this(storageHolder, usercentricsLogger, jsonParser, n);
        }

        @NotNull
        public final Builder addMigration(Migration ... migration) {
            Intrinsics.checkNotNullParameter((Object)migration, (String)"migration");
            CollectionsKt.addAll((Collection)this.migrations, (Object[])migration);
            return this;
        }

        @NotNull
        public final DeviceStorage build() {
            UsercentricsDeviceStorage deviceStorage = new UsercentricsDeviceStorage(this.storageHolder, this.logger, this.currentVersion, this.migrations, this.jsonParser, null);
            deviceStorage.init();
            return deviceStorage;
        }
    }
}

