/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.services.deviceStorage.migrations;

import com.usercentrics.sdk.core.json.JsonParser;
import com.usercentrics.sdk.core.json.JsonParserKt;
import com.usercentrics.sdk.core.time.DateTime;
import com.usercentrics.sdk.services.deviceStorage.StorageHolder;
import com.usercentrics.sdk.services.deviceStorage.migrations.Migration;
import com.usercentrics.sdk.v2.file.IFileStorage;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000fH\u0002R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lcom/usercentrics/sdk/services/deviceStorage/migrations/MigrationToVersion8;", "Lcom/usercentrics/sdk/services/deviceStorage/migrations/Migration;", "storageHolder", "Lcom/usercentrics/sdk/services/deviceStorage/StorageHolder;", "jsonParser", "Lcom/usercentrics/sdk/core/json/JsonParser;", "fileStorage", "Lcom/usercentrics/sdk/v2/file/IFileStorage;", "(Lcom/usercentrics/sdk/services/deviceStorage/StorageHolder;Lcom/usercentrics/sdk/core/json/JsonParser;Lcom/usercentrics/sdk/v2/file/IFileStorage;)V", "cacheMaxAge", "", "getCacheMaxAge", "()J", "dirsRequiringLanguageCodeAddition", "", "", "newFileSuffix", "getNewFileSuffix", "()Ljava/lang/String;", "migrate", "", "renameFile", "currentDir", "updateFileWithLanguageCode", "languageCode", "usercentrics_release"})
@SourceDebugExtension(value={"SMAP\nMigrationToVersion8.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MigrationToVersion8.kt\ncom/usercentrics/sdk/services/deviceStorage/migrations/MigrationToVersion8\n+ 2 JsonParser.kt\ncom/usercentrics/sdk/core/json/JsonParser\n+ 3 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 4 Serializers.kt\nkotlinx/serialization/SerializersKt__SerializersKt\n+ 5 Platform.common.kt\nkotlinx/serialization/internal/Platform_commonKt\n*L\n1#1,93:1\n24#2:94\n123#3:95\n32#4:96\n80#5:97\n*S KotlinDebug\n*F\n+ 1 MigrationToVersion8.kt\ncom/usercentrics/sdk/services/deviceStorage/migrations/MigrationToVersion8\n*L\n37#1:94\n37#1:95\n37#1:96\n37#1:97\n*E\n"})
public final class MigrationToVersion8
extends Migration {
    @NotNull
    private final JsonParser jsonParser;
    @NotNull
    private final IFileStorage fileStorage;
    @NotNull
    private final List<String> dirsRequiringLanguageCodeAddition;

    public MigrationToVersion8(@NotNull StorageHolder storageHolder, @NotNull JsonParser jsonParser, @NotNull IFileStorage fileStorage2) {
        Intrinsics.checkNotNullParameter((Object)storageHolder, (String)"storageHolder");
        Intrinsics.checkNotNullParameter((Object)jsonParser, (String)"jsonParser");
        Intrinsics.checkNotNullParameter((Object)fileStorage2, (String)"fileStorage");
        super(storageHolder, 8);
        this.jsonParser = jsonParser;
        this.fileStorage = fileStorage2;
        Object[] objectArray = new String[]{"settings", "aggregator", "translations", "tcf-declarations"};
        this.dirsRequiringLanguageCodeAddition = CollectionsKt.listOf((Object[])objectArray);
    }

    private final long getCacheMaxAge() {
        return new DateTime().addSeconds(1800).timestamp();
    }

    private final String getNewFileSuffix() {
        return "@#$" + this.getCacheMaxAge();
    }

    @Override
    public void migrate() {
        try {
            Map<String, String> settings = this.getStorageHolder().getUsercentricsKeyValueStorage().getStringWithKeyStartingWith("settings-");
            if (settings.isEmpty()) {
                return;
            }
            String settingsJson = (String)((Map.Entry)CollectionsKt.first((Iterable)settings.entrySet())).getValue();
            if (StringsKt.isBlank((CharSequence)settingsJson)) {
                return;
            }
            JsonParser this_$iv = this.jsonParser;
            boolean $i$f$decodeFromString22 = false;
            Object $this$decodeFromString$iv$iv = (StringFormat)JsonParserKt.access$getJson$p();
            boolean $i$f$decodeFromString = false;
            SerializersModule $this$serializer$iv$iv$iv = $this$decodeFromString$iv$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(JsonObject.class));
            boolean $i$f$cast = false;
            Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
            JsonObject settingsJsonObject = (JsonObject)$this$decodeFromString$iv$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv$iv, settingsJson);
            JsonElement jsonElement = (JsonElement)settingsJsonObject.get((Object)"language");
            String settingsLanguageValue = jsonElement != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? jsonElement.getContent() : null;
            CharSequence $i$f$decodeFromString22 = settingsLanguageValue;
            if ($i$f$decodeFromString22 == null || StringsKt.isBlank((CharSequence)$i$f$decodeFromString22)) {
                return;
            }
            List<String> directoriesStored = this.fileStorage.ls("");
            $this$decodeFromString$iv$iv = directoriesStored;
            if ($this$decodeFromString$iv$iv == null || $this$decodeFromString$iv$iv.isEmpty()) {
                return;
            }
            String etagsDir = (String)CollectionsKt.first(directoriesStored);
            List<String> etagContentDirs = this.fileStorage.ls(etagsDir);
            Collection collection = etagContentDirs;
            if (collection == null || collection.isEmpty()) {
                return;
            }
            for (String dir : etagContentDirs) {
                if (this.dirsRequiringLanguageCodeAddition.contains(dir)) {
                    this.updateFileWithLanguageCode(etagsDir + "/" + dir, settingsLanguageValue);
                    continue;
                }
                this.renameFile(etagsDir + "/" + dir);
            }
        }
        catch (Exception e) {
            this.fileStorage.rmAll();
        }
    }

    private final void updateFileWithLanguageCode(String currentDir, String languageCode) {
        List<String> list = this.fileStorage.ls(currentDir);
        if (list == null || (list = (String)CollectionsKt.firstOrNull(list)) == null) {
            return;
        }
        List<String> cachedFileName = list;
        String newDir = currentDir + "-" + languageCode;
        String currentFilePath = currentDir + "/" + (String)((Object)cachedFileName);
        String newFileName = newDir + "/" + (String)((Object)cachedFileName) + this.getNewFileSuffix();
        this.fileStorage.mkdir(newDir);
        this.fileStorage.copy(currentFilePath, newFileName);
        this.fileStorage.rmdir(currentDir);
    }

    private final void renameFile(String currentDir) {
        List<String> list = this.fileStorage.ls(currentDir);
        if (list == null || (list = (String)CollectionsKt.firstOrNull(list)) == null) {
            return;
        }
        List<String> cachedFileName = list;
        String currentFilePath = currentDir + "/" + (String)((Object)cachedFileName);
        String newFileName = currentDir + "/" + (String)((Object)cachedFileName) + this.getNewFileSuffix();
        this.fileStorage.copy(currentFilePath, newFileName);
        this.fileStorage.rm(currentFilePath);
    }
}

