/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.services.initialValues;

import com.usercentrics.sdk.acm.service.AdditionalConsentModeService;
import com.usercentrics.sdk.core.settings.SettingsOrchestrator;
import com.usercentrics.sdk.core.time.DateTime;
import com.usercentrics.sdk.log.UsercentricsLogger;
import com.usercentrics.sdk.models.common.InitialView;
import com.usercentrics.sdk.models.common.UsercentricsVariant;
import com.usercentrics.sdk.models.dataFacade.MergedServicesSettings;
import com.usercentrics.sdk.models.settings.LegacyConsent;
import com.usercentrics.sdk.models.settings.LegacyConsentHistoryEntry;
import com.usercentrics.sdk.models.settings.LegacyExtendedSettings;
import com.usercentrics.sdk.models.settings.LegacyService;
import com.usercentrics.sdk.models.settings.UsercentricsConsentAction;
import com.usercentrics.sdk.models.settings.UsercentricsConsentType;
import com.usercentrics.sdk.services.dataFacade.DataFacade;
import com.usercentrics.sdk.services.deviceStorage.DeviceStorage;
import com.usercentrics.sdk.services.initialValues.InitialValuesStrategy;
import com.usercentrics.sdk.services.initialValues.variants.CCPAInitialViewOptions;
import com.usercentrics.sdk.services.initialValues.variants.CCPAStrategy;
import com.usercentrics.sdk.services.initialValues.variants.GDPRInitialViewOptions;
import com.usercentrics.sdk.services.initialValues.variants.GDPRStrategy;
import com.usercentrics.sdk.services.initialValues.variants.SharedInitialViewOptions;
import com.usercentrics.sdk.services.initialValues.variants.StrategyReasonsKt;
import com.usercentrics.sdk.services.initialValues.variants.TCFInitialViewOptions;
import com.usercentrics.sdk.services.initialValues.variants.TCFStrategy;
import com.usercentrics.sdk.services.settings.ISettingsLegacy;
import com.usercentrics.sdk.services.tcf.TCFUseCase;
import com.usercentrics.sdk.v2.location.data.UsercentricsLocation;
import com.usercentrics.sdk.v2.location.service.ILocationService;
import com.usercentrics.sdk.v2.settings.data.CCPARegion;
import com.usercentrics.sdk.v2.settings.data.CCPASettings;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000 I2\u00020\u0001:\u0001IB]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u001e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0002J\u001e\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&H\u0096@\u00a2\u0006\u0002\u0010,J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0002J\u0010\u00100\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u00020$2\u0006\u00102\u001a\u000203H\u0002J \u00107\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J\u0018\u00108\u001a\u00020$2\u0006\u0010+\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&H\u0016J\u0006\u00109\u001a\u00020$J\b\u0010:\u001a\u00020$H\u0002J\u001a\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010%\u001a\u00020&2\u0006\u0010=\u001a\u00020\u001aH\u0002J\b\u0010>\u001a\u00020?H\u0016J\u001f\u0010@\u001a\u00020\u001a2\b\u0010A\u001a\u0004\u0018\u00010.2\u0006\u0010B\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010CJ\u0018\u0010D\u001a\u00020\u001e2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J \u0010=\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00102\u001a\u0002032\u0006\u0010E\u001a\u00020\u001aH\u0002J\u0017\u0010F\u001a\u00020\u001a2\b\u0010G\u001a\u0004\u0018\u00010.H\u0002\u00a2\u0006\u0002\u0010HR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006J\u00b2\u0006\n\u0010K\u001a\u000205X\u008a\u0084\u0002"}, d2={"Lcom/usercentrics/sdk/services/initialValues/InitialValuesStrategyImpl;", "Lcom/usercentrics/sdk/services/initialValues/InitialValuesStrategy;", "dataFacade", "Lcom/usercentrics/sdk/services/dataFacade/DataFacade;", "deviceStorage", "Lcom/usercentrics/sdk/services/deviceStorage/DeviceStorage;", "settingsLegacy", "Lcom/usercentrics/sdk/services/settings/ISettingsLegacy;", "locationService", "Lcom/usercentrics/sdk/v2/location/service/ILocationService;", "tcf", "Lcom/usercentrics/sdk/services/tcf/TCFUseCase;", "ccpaStrategy", "Lcom/usercentrics/sdk/services/initialValues/variants/CCPAStrategy;", "tcfStrategy", "Lcom/usercentrics/sdk/services/initialValues/variants/TCFStrategy;", "gdprStrategy", "Lcom/usercentrics/sdk/services/initialValues/variants/GDPRStrategy;", "settingsOrchestrator", "Lcom/usercentrics/sdk/core/settings/SettingsOrchestrator;", "additionalConsentModeService", "Lcom/usercentrics/sdk/acm/service/AdditionalConsentModeService;", "logger", "Lcom/usercentrics/sdk/log/UsercentricsLogger;", "(Lcom/usercentrics/sdk/services/dataFacade/DataFacade;Lcom/usercentrics/sdk/services/deviceStorage/DeviceStorage;Lcom/usercentrics/sdk/services/settings/ISettingsLegacy;Lcom/usercentrics/sdk/v2/location/service/ILocationService;Lcom/usercentrics/sdk/services/tcf/TCFUseCase;Lcom/usercentrics/sdk/services/initialValues/variants/CCPAStrategy;Lcom/usercentrics/sdk/services/initialValues/variants/TCFStrategy;Lcom/usercentrics/sdk/services/initialValues/variants/GDPRStrategy;Lcom/usercentrics/sdk/core/settings/SettingsOrchestrator;Lcom/usercentrics/sdk/acm/service/AdditionalConsentModeService;Lcom/usercentrics/sdk/log/UsercentricsLogger;)V", "noShowFlag", "", "getNoShowFlag", "()Z", "variant", "Lcom/usercentrics/sdk/models/common/UsercentricsVariant;", "getVariant", "()Lcom/usercentrics/sdk/models/common/UsercentricsVariant;", "setVariant", "(Lcom/usercentrics/sdk/models/common/UsercentricsVariant;)V", "acceptAllImplicitly", "", "controllerId", "", "services", "", "Lcom/usercentrics/sdk/models/settings/LegacyService;", "boot", "isFirstInitialization", "(ZLjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "convertToManualResurfaceTimestamp", "", "timestamp", "denyAllImplicitly", "getVariantForCCPA", "settings", "Lcom/usercentrics/sdk/models/settings/LegacyExtendedSettings;", "location", "Lcom/usercentrics/sdk/v2/location/data/UsercentricsLocation;", "initializeCCPAStringTheFirstTime", "initializeImplicitConsentTheFirstTime", "loadConsents", "loadVariant", "logAcceptAllImplicitly", "mergeSettingsFromStorage", "Lcom/usercentrics/sdk/models/dataFacade/MergedServicesSettings;", "shouldAcceptAllImplicitlyOnInit", "resolveInitialView", "Lcom/usercentrics/sdk/models/common/InitialView;", "resolveReshow", "lastInteractionTimestamp", "shouldReshowAfterVersionUpgrade", "(Ljava/lang/Long;Z)Z", "resolveVariant", "isInEU", "shouldManualResurface", "manualResurfaceTimestamp", "(Ljava/lang/Long;)Z", "Companion", "usercentrics_release", "locationValue"})
@SourceDebugExtension(value={"SMAP\nInitialValuesStrategyImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InitialValuesStrategyImpl.kt\ncom/usercentrics/sdk/services/initialValues/InitialValuesStrategyImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,305:1\n1855#2,2:306\n1855#2,2:308\n*S KotlinDebug\n*F\n+ 1 InitialValuesStrategyImpl.kt\ncom/usercentrics/sdk/services/initialValues/InitialValuesStrategyImpl\n*L\n139#1:306,2\n175#1:308,2\n*E\n"})
public final class InitialValuesStrategyImpl
implements InitialValuesStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataFacade dataFacade;
    @NotNull
    private final DeviceStorage deviceStorage;
    @NotNull
    private final ISettingsLegacy settingsLegacy;
    @NotNull
    private final ILocationService locationService;
    @NotNull
    private final TCFUseCase tcf;
    @NotNull
    private final CCPAStrategy ccpaStrategy;
    @NotNull
    private final TCFStrategy tcfStrategy;
    @NotNull
    private final GDPRStrategy gdprStrategy;
    @NotNull
    private final SettingsOrchestrator settingsOrchestrator;
    @NotNull
    private final AdditionalConsentModeService additionalConsentModeService;
    @NotNull
    private final UsercentricsLogger logger;
    @Nullable
    private UsercentricsVariant variant;
    @NotNull
    private static final CCPARegion defaultCCPARegion = CCPARegion.US_CA_ONLY;

    public InitialValuesStrategyImpl(@NotNull DataFacade dataFacade, @NotNull DeviceStorage deviceStorage, @NotNull ISettingsLegacy settingsLegacy, @NotNull ILocationService locationService2, @NotNull TCFUseCase tcf, @NotNull CCPAStrategy ccpaStrategy, @NotNull TCFStrategy tcfStrategy, @NotNull GDPRStrategy gdprStrategy, @NotNull SettingsOrchestrator settingsOrchestrator2, @NotNull AdditionalConsentModeService additionalConsentModeService2, @NotNull UsercentricsLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)dataFacade, (String)"dataFacade");
        Intrinsics.checkNotNullParameter((Object)deviceStorage, (String)"deviceStorage");
        Intrinsics.checkNotNullParameter((Object)settingsLegacy, (String)"settingsLegacy");
        Intrinsics.checkNotNullParameter((Object)locationService2, (String)"locationService");
        Intrinsics.checkNotNullParameter((Object)tcf, (String)"tcf");
        Intrinsics.checkNotNullParameter((Object)ccpaStrategy, (String)"ccpaStrategy");
        Intrinsics.checkNotNullParameter((Object)tcfStrategy, (String)"tcfStrategy");
        Intrinsics.checkNotNullParameter((Object)gdprStrategy, (String)"gdprStrategy");
        Intrinsics.checkNotNullParameter((Object)settingsOrchestrator2, (String)"settingsOrchestrator");
        Intrinsics.checkNotNullParameter((Object)additionalConsentModeService2, (String)"additionalConsentModeService");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.dataFacade = dataFacade;
        this.deviceStorage = deviceStorage;
        this.settingsLegacy = settingsLegacy;
        this.locationService = locationService2;
        this.tcf = tcf;
        this.ccpaStrategy = ccpaStrategy;
        this.tcfStrategy = tcfStrategy;
        this.gdprStrategy = gdprStrategy;
        this.settingsOrchestrator = settingsOrchestrator2;
        this.additionalConsentModeService = additionalConsentModeService2;
        this.logger = logger2;
    }

    private final boolean getNoShowFlag() {
        return this.settingsOrchestrator.getNoShow();
    }

    @Override
    @Nullable
    public UsercentricsVariant getVariant() {
        return this.variant;
    }

    public void setVariant(@Nullable UsercentricsVariant usercentricsVariant) {
        this.variant = usercentricsVariant;
    }

    @Override
    @Nullable
    public Object boot(boolean isFirstInitialization, @NotNull String controllerId, @NotNull Continuation<? super Unit> $completion) {
        this.loadVariant();
        this.loadConsents(isFirstInitialization, controllerId);
        return Unit.INSTANCE;
    }

    public final void loadVariant() {
        LegacyExtendedSettings settings = this.settingsLegacy.getSettings();
        UsercentricsLocation location = this.locationService.getLocation();
        this.setVariant(this.resolveVariant(settings, location));
    }

    private final UsercentricsVariant resolveVariant(LegacyExtendedSettings settings, UsercentricsLocation location) {
        CCPASettings cCPASettings = settings.getCcpa();
        boolean isCCPAEnabled = (cCPASettings != null ? cCPASettings.isActive() : false) || settings.getFramework() != null;
        boolean isTCFEnabled = settings.isTcfEnabled();
        return isCCPAEnabled ? this.getVariantForCCPA(settings, location) : (isTCFEnabled ? UsercentricsVariant.TCF : UsercentricsVariant.DEFAULT);
    }

    private final UsercentricsVariant getVariantForCCPA(LegacyExtendedSettings settings, UsercentricsLocation location) {
        UsercentricsVariant usercentricsVariant;
        Object object = settings.getCcpa();
        if (object == null || (object = ((CCPASettings)object).getRegion()) == null) {
            object = defaultCCPARegion;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()]) {
            case 1: {
                if (location.isInCalifornia()) {
                    usercentricsVariant = UsercentricsVariant.CCPA;
                    break;
                }
                usercentricsVariant = UsercentricsVariant.DEFAULT;
                break;
            }
            case 2: {
                if (location.isInUS()) {
                    usercentricsVariant = UsercentricsVariant.CCPA;
                    break;
                }
                usercentricsVariant = UsercentricsVariant.DEFAULT;
                break;
            }
            case 3: {
                usercentricsVariant = UsercentricsVariant.CCPA;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return usercentricsVariant;
    }

    @Override
    public void loadConsents(boolean isFirstInitialization, @NotNull String controllerId) {
        MergedServicesSettings mergedServicesSettings;
        Intrinsics.checkNotNullParameter((Object)controllerId, (String)"controllerId");
        LegacyExtendedSettings settings = this.settingsLegacy.getSettings();
        UsercentricsLocation location = this.locationService.getLocation();
        if (isFirstInitialization) {
            this.initializeImplicitConsentTheFirstTime(controllerId, settings, location);
            this.initializeCCPAStringTheFirstTime(settings);
            return;
        }
        UsercentricsVariant usercentricsVariant = this.getVariant();
        Intrinsics.checkNotNull((Object)((Object)usercentricsVariant));
        boolean shouldAcceptAllImplicitlyOnInit = this.shouldAcceptAllImplicitlyOnInit(usercentricsVariant, settings, location.isInEU());
        MergedServicesSettings mergedServicesSettings2 = mergedServicesSettings = this.mergeSettingsFromStorage(controllerId, shouldAcceptAllImplicitlyOnInit);
        List<LegacyService> newServices = mergedServicesSettings2 != null ? mergedServicesSettings2.getUpdatedNonEssentialServices() : null;
        Collection collection = newServices;
        if (!(collection == null || collection.isEmpty()) && shouldAcceptAllImplicitlyOnInit) {
            this.acceptAllImplicitly(controllerId, newServices);
        }
    }

    private final void initializeImplicitConsentTheFirstTime(String controllerId, LegacyExtendedSettings settings, UsercentricsLocation location) {
        UsercentricsVariant usercentricsVariant = this.getVariant();
        Intrinsics.checkNotNull((Object)((Object)usercentricsVariant));
        boolean shouldAcceptAllImplicitlyOnInit = this.shouldAcceptAllImplicitlyOnInit(usercentricsVariant, settings, location.isInEU());
        if (shouldAcceptAllImplicitlyOnInit) {
            this.acceptAllImplicitly(controllerId);
        } else {
            this.denyAllImplicitly(controllerId);
        }
    }

    private final void initializeCCPAStringTheFirstTime(LegacyExtendedSettings settings) {
        CCPASettings cCPASettings = settings.getCcpa();
        boolean bl = cCPASettings != null ? cCPASettings.isActive() : false;
        if (bl && this.getVariant() != UsercentricsVariant.CCPA) {
            this.ccpaStrategy.setNotApplicable();
        }
    }

    private final boolean shouldAcceptAllImplicitlyOnInit(UsercentricsVariant variant, LegacyExtendedSettings settings, boolean isInEU) {
        boolean bl;
        if (this.getNoShowFlag()) {
            return true;
        }
        switch (WhenMappings.$EnumSwitchMapping$1[variant.ordinal()]) {
            case 1: {
                bl = this.ccpaStrategy.shouldAcceptAllImplicitlyOnInit();
                break;
            }
            case 2: {
                bl = this.tcfStrategy.shouldAcceptAllImplicitlyOnInit(this.tcf.getGdprAppliesOnTCF());
                break;
            }
            case 3: {
                bl = this.gdprStrategy.shouldAcceptAllImplicitlyOnInit(settings.getGdpr(), isInEU);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final void acceptAllImplicitly(String controllerId) {
        this.acceptAllImplicitly(controllerId, this.settingsLegacy.getSettings().getServices());
    }

    private final void acceptAllImplicitly(String controllerId, List<LegacyService> services) {
        Iterable $this$forEach$iv = services;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LegacyService it = (LegacyService)element$iv;
            boolean bl = false;
            List<LegacyConsentHistoryEntry> list = it.getConsent().getHistory();
            it.setConsent(new LegacyConsent(list, true));
        }
        this.dataFacade.execute(controllerId, services, UsercentricsConsentAction.NON_EU_REGION, UsercentricsConsentType.IMPLICIT);
        if (this.settingsLegacy.isTCFEnabled()) {
            this.tcf.updateIABTCFKeys("");
            if (this.settingsLegacy.isAdditionalConsentModeEnabled()) {
                this.additionalConsentModeService.acceptAll();
            }
        }
        this.logAcceptAllImplicitly();
    }

    private final void logAcceptAllImplicitly() {
        String string;
        String framework = this.settingsLegacy.getSettings().getFramework();
        UsercentricsVariant usercentricsVariant = this.getVariant();
        switch (usercentricsVariant == null ? -1 : WhenMappings.$EnumSwitchMapping$1[usercentricsVariant.ordinal()]) {
            case 1: {
                string = StrategyReasonsKt.formatUSFrameworkMessage("##us_framework## | Accept all implicitly cause: It is the first initialization", framework);
                break;
            }
            case 2: {
                string = "TCF | Accept all non-IAB services implicitly cause: The 'Apply GDPR only to EU users' option is enabled and it is the first initialization";
                break;
            }
            case 3: {
                string = "GDPR | Accept all implicitly cause: It is the first initialization, the 'Display CMP only to EU users' option is enabled and the user is not in EU";
                break;
            }
            default: {
                string = "";
            }
        }
        String message = string;
        UsercentricsLogger.DefaultImpls.debug$default(this.logger, message, null, 2, null);
    }

    /*
     * Unable to fully structure code
     */
    private final void denyAllImplicitly(String controllerId) {
        services = this.settingsLegacy.getSettings().getServices();
        $this$forEach$iv = services;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (LegacyService)element$iv;
            $i$a$-forEach-InitialValuesStrategyImpl$denyAllImplicitly$1 = false;
            if (it.isEssential()) ** GOTO lbl-1000
            v0 = it.getDefaultConsentStatus();
            if (v0 != null ? v0 : false) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            var9_9 = v1;
            var10_10 = it.getConsent().getHistory();
            it.setConsent(new LegacyConsent(var10_10, var9_9));
        }
        this.dataFacade.execute(controllerId, services, UsercentricsConsentAction.INITIAL_PAGE_LOAD, UsercentricsConsentType.IMPLICIT);
        if (this.settingsLegacy.isTCFEnabled()) {
            this.tcf.updateIABTCFKeys("");
            if (this.settingsLegacy.isAdditionalConsentModeEnabled()) {
                this.additionalConsentModeService.denyAll();
            }
        }
    }

    private final MergedServicesSettings mergeSettingsFromStorage(String controllerId, boolean shouldAcceptAllImplicitlyOnInit) {
        return this.dataFacade.mergeSettingsFromStorage(controllerId, shouldAcceptAllImplicitlyOnInit);
    }

    @Override
    @NotNull
    public InitialView resolveInitialView() {
        InitialView initialView;
        Long l;
        if (this.getNoShowFlag()) {
            return InitialView.NONE;
        }
        UsercentricsVariant usercentricsVariant = this.getVariant();
        if (usercentricsVariant == null) {
            throw new IllegalStateException("No variant value");
        }
        UsercentricsVariant variantValue = usercentricsVariant;
        Lazy locationValue$delegate = LazyKt.lazy((Function0)((Function0)new Function0<UsercentricsLocation>(this){
            final /* synthetic */ InitialValuesStrategyImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final UsercentricsLocation invoke() {
                return InitialValuesStrategyImpl.access$getLocationService$p(this.this$0).getLocation();
            }
        }));
        LegacyExtendedSettings settings = this.settingsLegacy.getSettings();
        Long l2 = settings.getRenewConsentsTimestampInSeconds();
        if (l2 != null) {
            long timestamp = ((Number)l2).longValue();
            boolean bl = false;
            l = this.convertToManualResurfaceTimestamp(timestamp);
        } else {
            l = null;
        }
        Long manualResurfaceTimestamp = l;
        boolean versionChangeRequiresReshow = this.resolveReshow(this.deviceStorage.lastInteractionTimestamp(), this.deviceStorage.getUserActionRequired());
        boolean shouldManualResurface = this.shouldManualResurface(manualResurfaceTimestamp);
        SharedInitialViewOptions sharedInitialViewOptions = new SharedInitialViewOptions(versionChangeRequiresReshow, shouldManualResurface);
        switch (WhenMappings.$EnumSwitchMapping$1[variantValue.ordinal()]) {
            case 1: {
                CCPAInitialViewOptions ccpaInitialViewOptions = new CCPAInitialViewOptions(settings.getCcpa(), settings.getFramework(), sharedInitialViewOptions);
                initialView = this.ccpaStrategy.getInitialView(ccpaInitialViewOptions);
                break;
            }
            case 2: {
                TCFInitialViewOptions tcfInitialViewOptions = new TCFInitialViewOptions(this.tcf.getResurfacePurposeChanged(), this.tcf.getResurfaceVendorAdded(), this.gdprStrategy.noGDPRConsentActionPerformed(), this.tcf.getResurfacePeriodEnded(), this.tcf.getSettingsTCFPolicyVersion(), this.tcf.getStoredTcStringPolicyVersion(), this.tcf.getResurfaceATPChanged(), sharedInitialViewOptions);
                initialView = this.tcfStrategy.getInitialView(tcfInitialViewOptions);
                break;
            }
            case 3: {
                GDPRInitialViewOptions gdprInitialViewOptions = new GDPRInitialViewOptions(settings.getGdpr(), InitialValuesStrategyImpl.resolveInitialView$lambda$2((Lazy<UsercentricsLocation>)locationValue$delegate).isInEU(), sharedInitialViewOptions);
                initialView = this.gdprStrategy.getInitialView(gdprInitialViewOptions);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return initialView;
    }

    private final boolean shouldManualResurface(Long manualResurfaceTimestamp) {
        if (manualResurfaceTimestamp == null) {
            return false;
        }
        Long l = this.deviceStorage.lastInteractionTimestamp();
        long lastInteractionTimestamp = l != null ? l : 0L;
        boolean isAfterManualResurface = new DateTime().timestamp() > manualResurfaceTimestamp;
        boolean wasLastInteractionBeforeResurface = lastInteractionTimestamp < manualResurfaceTimestamp;
        return isAfterManualResurface && wasLastInteractionBeforeResurface;
    }

    private final long convertToManualResurfaceTimestamp(long timestamp) {
        return timestamp * (long)1000;
    }

    private final boolean resolveReshow(Long lastInteractionTimestamp, boolean shouldReshowAfterVersionUpgrade) {
        if (lastInteractionTimestamp == null) {
            return false;
        }
        return shouldReshowAfterVersionUpgrade;
    }

    private static final UsercentricsLocation resolveInitialView$lambda$2(Lazy<UsercentricsLocation> $locationValue$delegate) {
        Lazy<UsercentricsLocation> lazy = $locationValue$delegate;
        return (UsercentricsLocation)lazy.getValue();
    }

    public static final /* synthetic */ ILocationService access$getLocationService$p(InitialValuesStrategyImpl $this) {
        return $this.locationService;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/usercentrics/sdk/services/initialValues/InitialValuesStrategyImpl$Companion;", "", "()V", "defaultCCPARegion", "Lcom/usercentrics/sdk/v2/settings/data/CCPARegion;", "usercentrics_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[CCPARegion.values().length];
            try {
                nArray[CCPARegion.US_CA_ONLY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CCPARegion.US.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CCPARegion.ALL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[UsercentricsVariant.values().length];
            try {
                nArray[UsercentricsVariant.CCPA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UsercentricsVariant.TCF.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UsercentricsVariant.DEFAULT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

