/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.services.initialValues.variants;

import com.usercentrics.sdk.core.time.DateTime;
import com.usercentrics.sdk.log.UsercentricsLogger;
import com.usercentrics.sdk.models.common.InitialView;
import com.usercentrics.sdk.services.ccpa.ICcpa;
import com.usercentrics.sdk.services.deviceStorage.DeviceStorage;
import com.usercentrics.sdk.services.initialValues.variants.CCPAInitialViewOptions;
import com.usercentrics.sdk.services.initialValues.variants.CCPAStrategy;
import com.usercentrics.sdk.services.initialValues.variants.SharedInitialViewOptions;
import com.usercentrics.sdk.services.initialValues.variants.StrategyReasonsKt;
import com.usercentrics.sdk.v2.settings.data.CCPASettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J!\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/usercentrics/sdk/services/initialValues/variants/CCPAStrategyImpl;", "Lcom/usercentrics/sdk/services/initialValues/variants/CCPAStrategy;", "logger", "Lcom/usercentrics/sdk/log/UsercentricsLogger;", "deviceStorage", "Lcom/usercentrics/sdk/services/deviceStorage/DeviceStorage;", "ccpa", "Lcom/usercentrics/sdk/services/ccpa/ICcpa;", "(Lcom/usercentrics/sdk/log/UsercentricsLogger;Lcom/usercentrics/sdk/services/deviceStorage/DeviceStorage;Lcom/usercentrics/sdk/services/ccpa/ICcpa;)V", "getInitialView", "Lcom/usercentrics/sdk/models/common/InitialView;", "ccpaInitialViewOptions", "Lcom/usercentrics/sdk/services/initialValues/variants/CCPAInitialViewOptions;", "setNotApplicable", "", "shouldAcceptAllImplicitlyOnInit", "", "timeToReshowHasPassed", "ccpaOptions", "Lcom/usercentrics/sdk/v2/settings/data/CCPASettings;", "lastTimestamp", "", "(Lcom/usercentrics/sdk/v2/settings/data/CCPASettings;Ljava/lang/Long;)Z", "usercentrics_release"})
public final class CCPAStrategyImpl
implements CCPAStrategy {
    @NotNull
    private final UsercentricsLogger logger;
    @NotNull
    private final DeviceStorage deviceStorage;
    @NotNull
    private final ICcpa ccpa;

    public CCPAStrategyImpl(@NotNull UsercentricsLogger logger2, @NotNull DeviceStorage deviceStorage, @NotNull ICcpa ccpa) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)deviceStorage, (String)"deviceStorage");
        Intrinsics.checkNotNullParameter((Object)ccpa, (String)"ccpa");
        this.logger = logger2;
        this.deviceStorage = deviceStorage;
        this.ccpa = ccpa;
    }

    @Override
    public boolean shouldAcceptAllImplicitlyOnInit() {
        return true;
    }

    @Override
    public void setNotApplicable() {
        this.ccpa.setNotApplicable();
    }

    @Override
    @NotNull
    public InitialView getInitialView(@NotNull CCPAInitialViewOptions ccpaInitialViewOptions) {
        InitialView initialView;
        Intrinsics.checkNotNullParameter((Object)ccpaInitialViewOptions, (String)"ccpaInitialViewOptions");
        Boolean isOptedOut = this.ccpa.getCCPAData().getOptedOut();
        Long lastTimestamp = this.deviceStorage.getCcpaTimestampInMillis();
        boolean isFirstInitialization = lastTimestamp == null;
        CCPASettings cCPASettings = ccpaInitialViewOptions.getCcpaOptions();
        boolean showOnFirstTimeVisit = cCPASettings != null ? cCPASettings.getShowOnPageLoad() : false;
        SharedInitialViewOptions sharedInitialViewOptions = ccpaInitialViewOptions.getSharedInitialViewOptions();
        if (sharedInitialViewOptions.getManualResurface()) {
            UsercentricsLogger.DefaultImpls.debug$default(this.logger, "SHOW_CMP cause: The 'Manual Resurface option' on Admin Interface was triggered", null, 2, null);
            initialView = InitialView.FIRST_LAYER;
        } else if (sharedInitialViewOptions.getVersionChangeRequiresReshow()) {
            UsercentricsLogger.DefaultImpls.debug$default(this.logger, "SHOW_CMP cause: Settings version has changed", null, 2, null);
            initialView = InitialView.FIRST_LAYER;
        } else if (Intrinsics.areEqual((Object)isOptedOut, (Object)false)) {
            initialView = InitialView.NONE;
        } else if (isFirstInitialization && showOnFirstTimeVisit) {
            UsercentricsLogger.DefaultImpls.debug$default(this.logger, StrategyReasonsKt.formatUSFrameworkMessage("SHOW_CMP cause: [##us_framework##] The 'Show CMP on first time visit' option is enabled and it is the first initialization", ccpaInitialViewOptions.getFramework()), null, 2, null);
            initialView = InitialView.FIRST_LAYER;
        } else if (this.timeToReshowHasPassed(ccpaInitialViewOptions.getCcpaOptions(), lastTimestamp)) {
            UsercentricsLogger.DefaultImpls.debug$default(this.logger, StrategyReasonsKt.formatUSFrameworkMessage("SHOW_CMP cause: [##us_framework##] The 'Reshow ##us_framework## CMP' configured time has passed", ccpaInitialViewOptions.getFramework()), null, 2, null);
            initialView = InitialView.FIRST_LAYER;
        } else {
            initialView = InitialView.NONE;
        }
        return initialView;
    }

    private final boolean timeToReshowHasPassed(CCPASettings ccpaOptions, Long lastTimestamp) {
        Integer reshowCmpInDays;
        CCPASettings cCPASettings = ccpaOptions;
        Integer n = reshowCmpInDays = cCPASettings != null ? Integer.valueOf(cCPASettings.getReshowAfterDays()) : null;
        if (reshowCmpInDays == null || lastTimestamp == null) {
            return false;
        }
        DateTime sessionDateTime = new DateTime(lastTimestamp);
        int elapsedDays = new DateTime().getDay() - sessionDateTime.getDay();
        return elapsedDays > reshowCmpInDays;
    }
}

