/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.services.initialValues.variants;

import com.usercentrics.sdk.core.time.DateTime;
import com.usercentrics.sdk.log.UsercentricsLogger;
import com.usercentrics.sdk.models.common.InitialView;
import com.usercentrics.sdk.models.settings.GDPROptions;
import com.usercentrics.sdk.services.deviceStorage.DeviceStorage;
import com.usercentrics.sdk.services.initialValues.variants.GDPRInitialViewOptions;
import com.usercentrics.sdk.services.initialValues.variants.GDPRStrategy;
import com.usercentrics.sdk.services.initialValues.variants.SharedInitialViewOptions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000f\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000fH\u0016J\u001f\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/usercentrics/sdk/services/initialValues/variants/GDPRStrategyImpl;", "Lcom/usercentrics/sdk/services/initialValues/variants/GDPRStrategy;", "logger", "Lcom/usercentrics/sdk/log/UsercentricsLogger;", "deviceStorage", "Lcom/usercentrics/sdk/services/deviceStorage/DeviceStorage;", "(Lcom/usercentrics/sdk/log/UsercentricsLogger;Lcom/usercentrics/sdk/services/deviceStorage/DeviceStorage;)V", "getInitialView", "Lcom/usercentrics/sdk/models/common/InitialView;", "gdprInitialViewOptions", "Lcom/usercentrics/sdk/services/initialValues/variants/GDPRInitialViewOptions;", "lastServiceInteractionTimestamp", "", "()Ljava/lang/Long;", "noGDPRConsentActionPerformed", "", "shouldAcceptAllImplicitlyOnInit", "gdprOptions", "Lcom/usercentrics/sdk/models/settings/GDPROptions;", "isInEU", "timeToReshowHasPassed", "reshowBannerInMonths", "", "lastTimestamp", "(ILjava/lang/Long;)Z", "usercentrics_release"})
public final class GDPRStrategyImpl
implements GDPRStrategy {
    @NotNull
    private final UsercentricsLogger logger;
    @NotNull
    private final DeviceStorage deviceStorage;

    public GDPRStrategyImpl(@NotNull UsercentricsLogger logger2, @NotNull DeviceStorage deviceStorage) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)deviceStorage, (String)"deviceStorage");
        this.logger = logger2;
        this.deviceStorage = deviceStorage;
    }

    @Override
    public boolean shouldAcceptAllImplicitlyOnInit(@Nullable GDPROptions gdprOptions, boolean isInEU) {
        GDPROptions gDPROptions = gdprOptions;
        boolean displayCmpOnlyToEUUsers = gDPROptions != null ? gDPROptions.getDisplayCmpOnlyToEUUsers() : false;
        return displayCmpOnlyToEUUsers && !isInEU;
    }

    @Override
    @NotNull
    public InitialView getInitialView(@NotNull GDPRInitialViewOptions gdprInitialViewOptions) {
        InitialView initialView;
        GDPROptions gdprOptions;
        Intrinsics.checkNotNullParameter((Object)gdprInitialViewOptions, (String)"gdprInitialViewOptions");
        GDPROptions gDPROptions = gdprOptions = gdprInitialViewOptions.getGdprOptions();
        boolean displayCmpOnlyToEUUsers = gDPROptions != null ? gDPROptions.getDisplayCmpOnlyToEUUsers() : false;
        Object object = gdprOptions;
        int reshowBannerInMonths = object != null && (object = ((GDPROptions)object).getReshowCmpInMonths()) != null ? (Integer)object : 0;
        boolean noConsentActionPerformed = this.noGDPRConsentActionPerformed();
        SharedInitialViewOptions sharedInitialViewOptions = gdprInitialViewOptions.getSharedInitialViewOptions();
        if (sharedInitialViewOptions.getManualResurface()) {
            UsercentricsLogger.DefaultImpls.debug$default(this.logger, "SHOW_CMP cause: The 'Manual Resurface option' on Admin Interface was triggered", null, 2, null);
            initialView = InitialView.FIRST_LAYER;
        } else if (displayCmpOnlyToEUUsers && !gdprInitialViewOptions.isInEU()) {
            initialView = InitialView.NONE;
        } else if (noConsentActionPerformed) {
            UsercentricsLogger.DefaultImpls.debug$default(this.logger, "SHOW_CMP cause: [GDPR] This user has not yet provided consent", null, 2, null);
            initialView = InitialView.FIRST_LAYER;
        } else if (this.timeToReshowHasPassed(reshowBannerInMonths, this.lastServiceInteractionTimestamp())) {
            UsercentricsLogger.DefaultImpls.debug$default(this.logger, "SHOW_CMP cause: [GDPR] The 'Reshow GDPR CMP' option is enabled and the configured time has passed", null, 2, null);
            initialView = InitialView.FIRST_LAYER;
        } else if (sharedInitialViewOptions.getVersionChangeRequiresReshow()) {
            UsercentricsLogger.DefaultImpls.debug$default(this.logger, "SHOW_CMP cause: Settings version has changed", null, 2, null);
            initialView = InitialView.FIRST_LAYER;
        } else {
            initialView = InitialView.NONE;
        }
        return initialView;
    }

    @Override
    public boolean noGDPRConsentActionPerformed() {
        return this.lastServiceInteractionTimestamp() == null;
    }

    private final Long lastServiceInteractionTimestamp() {
        return this.deviceStorage.lastInteractionTimestamp();
    }

    private final boolean timeToReshowHasPassed(int reshowBannerInMonths, Long lastTimestamp) {
        if (reshowBannerInMonths == 0 || lastTimestamp == null) {
            return false;
        }
        DateTime currentTimestamp = new DateTime();
        DateTime lastInteractionPlusReshowBannerThreshold = new DateTime(lastTimestamp).addMonths(reshowBannerInMonths);
        return currentTimestamp.compareTo(lastInteractionPlusReshowBannerThreshold) > 0;
    }
}

