/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.v2.network;

import com.usercentrics.sdk.core.application.INetworkStrategy;
import com.usercentrics.sdk.core.time.DateTime;
import com.usercentrics.sdk.domain.api.http.HttpResponse;
import com.usercentrics.sdk.errors.UsercentricsException;
import com.usercentrics.sdk.log.UsercentricsLogger;
import com.usercentrics.sdk.v2.etag.cache.IEtagCacheStorage;
import com.usercentrics.sdk.v2.etag.repository.EtagRepository;
import com.usercentrics.sdk.v2.network.NetworkOrchestrator;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b \u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002J\u0014\u0010\r\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fJ6\u0010\u0010\u001a\u00020\n2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\u001c\u0010\u000e\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0013H\u0086@\u00a2\u0006\u0002\u0010\u0016J\u0014\u0010\u0017\u001a\u00020\u00182\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fJ6\u0010\u0019\u001a\u00020\u00182\b\b\u0002\u0010\u0011\u001a\u00020\u00122\u001c\u0010\u000e\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0013H\u0086@\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u001a\u001a\u00020\u0012H\u0002J\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/usercentrics/sdk/v2/network/NetworkOrchestrator;", "Lcom/usercentrics/sdk/v2/etag/repository/EtagRepository;", "logger", "Lcom/usercentrics/sdk/log/UsercentricsLogger;", "etagCacheStorage", "Lcom/usercentrics/sdk/v2/etag/cache/IEtagCacheStorage;", "networkStrategy", "Lcom/usercentrics/sdk/core/application/INetworkStrategy;", "(Lcom/usercentrics/sdk/log/UsercentricsLogger;Lcom/usercentrics/sdk/v2/etag/cache/IEtagCacheStorage;Lcom/usercentrics/sdk/core/application/INetworkStrategy;)V", "httpResponseFromCache", "Lcom/usercentrics/sdk/domain/api/http/HttpResponse;", "processResponse", "response", "resolveHttp", "apiRequest", "Lkotlin/Function0;", "resolveHttp2", "bypassCache", "", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "", "(ZLkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resolveHttpBody", "", "resolveHttpBody2", "shouldFetchResponseFromCache", "shouldLoadFromApi", "responseCode", "", "usercentrics_release"})
public abstract class NetworkOrchestrator
extends EtagRepository {
    @NotNull
    private final INetworkStrategy networkStrategy;

    public NetworkOrchestrator(@NotNull UsercentricsLogger logger2, @NotNull IEtagCacheStorage etagCacheStorage2, @NotNull INetworkStrategy networkStrategy2) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)etagCacheStorage2, (String)"etagCacheStorage");
        Intrinsics.checkNotNullParameter((Object)networkStrategy2, (String)"networkStrategy");
        super(logger2, etagCacheStorage2);
        this.networkStrategy = networkStrategy2;
    }

    @NotNull
    public final String resolveHttpBody(@NotNull Function0<HttpResponse> apiRequest) {
        Intrinsics.checkNotNullParameter(apiRequest, (String)"apiRequest");
        return this.resolveHttp(apiRequest).getBody();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object resolveHttpBody2(boolean var1_1, @NotNull Function1<? super Continuation<? super HttpResponse>, ? extends Object> var2_2, @NotNull Continuation<? super String> var3_3) {
        if (!(var3_3 instanceof resolveHttpBody2.1)) ** GOTO lbl-1000
        var5_4 = var3_3;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ NetworkOrchestrator this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.resolveHttpBody2(false, null, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.resolveHttp2(bypassCache != false, (Function1<? super Continuation<? super HttpResponse>, ? extends Object>)apiRequest, (Continuation<? super HttpResponse>)$continuation);
                if (v0 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                return ((HttpResponse)v0).getBody();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object resolveHttpBody2$default(NetworkOrchestrator networkOrchestrator, boolean bl, Function1 function1, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resolveHttpBody2");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return networkOrchestrator.resolveHttpBody2(bl, (Function1<? super Continuation<? super HttpResponse>, ? extends Object>)function1, (Continuation<? super String>)continuation);
    }

    @NotNull
    public final HttpResponse resolveHttp(@NotNull Function0<HttpResponse> apiRequest) {
        Intrinsics.checkNotNullParameter(apiRequest, (String)"apiRequest");
        if (this.networkStrategy.isOffline()) {
            return this.httpResponseFromCache();
        }
        HttpResponse response2 = (HttpResponse)apiRequest.invoke();
        return this.processResponse(response2);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object resolveHttp2(boolean var1_1, @NotNull Function1<? super Continuation<? super HttpResponse>, ? extends Object> var2_2, @NotNull Continuation<? super HttpResponse> var3_3) {
        block9: {
            if (!(var3_3 instanceof resolveHttp2.1)) ** GOTO lbl-1000
            var6_4 = var3_3;
            if ((var6_4.label & -2147483648) != 0) {
                var6_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var3_3){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ NetworkOrchestrator this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.resolveHttp2(false, null, (Continuation<? super HttpResponse>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (bypassCache == false) break;
                    var4_7 = this;
                    $continuation.L$0 = var4_7;
                    $continuation.label = 1;
                    v0 = apiRequest.invoke((Object)$continuation);
                    if (v0 == var7_6) {
                        return var7_6;
                    }
                    ** GOTO lbl25
                }
                case 1: {
                    var4_7 = (NetworkOrchestrator)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl25:
                    // 2 sources

                    v1 = var4_7.processResponse((HttpResponse)v0);
                    ** GOTO lbl43
                }
            }
            if (!this.shouldFetchResponseFromCache()) break block9;
            v1 = this.httpResponseFromCache();
            ** GOTO lbl43
        }
        var4_8 = this;
        $continuation.L$0 = var4_8;
        $continuation.label = 2;
        v2 = apiRequest.invoke((Object)$continuation);
        if (v2 == var7_6) {
            return var7_6;
        }
        ** GOTO lbl42
        {
            case 2: {
                var4_8 = (NetworkOrchestrator)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl42:
                // 2 sources

                v1 = var4_8.processResponse((HttpResponse)v2);
lbl43:
                // 3 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object resolveHttp2$default(NetworkOrchestrator networkOrchestrator, boolean bl, Function1 function1, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resolveHttp2");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return networkOrchestrator.resolveHttp2(bl, (Function1<? super Continuation<? super HttpResponse>, ? extends Object>)function1, (Continuation<? super HttpResponse>)continuation);
    }

    public final boolean shouldLoadFromApi(int responseCode) {
        return responseCode == 200;
    }

    private final boolean shouldFetchResponseFromCache() {
        long currentDateTime;
        if (this.networkStrategy.isOffline()) {
            return true;
        }
        long cachedEtagTimestamp = this.getCacheControlValueFromEtagFile();
        return cachedEtagTimestamp > (currentDateTime = new DateTime().timestamp());
    }

    private final HttpResponse processResponse(HttpResponse response2) {
        String string;
        switch (response2.getStatusCode()) {
            case 200: {
                string = this.getApiBody(response2, response2.parseCacheControl());
                break;
            }
            case 304: {
                string = this.getEtagFile();
                break;
            }
            default: {
                throw new UsercentricsException("Invalid Network Response", null, 2, null);
            }
        }
        String body = string;
        return new HttpResponse(response2.getHeaders(), body, response2.getStatusCode());
    }

    private final HttpResponse httpResponseFromCache() {
        return new HttpResponse(MapsKt.emptyMap(), this.getEtagFile(), 304);
    }
}

