/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.tcf.core.encoder;

import com.usercentrics.tcf.core.encoder.Base64Url;
import com.usercentrics.tcf.core.errors.DecodingError;
import com.usercentrics.tcf.core.errors.EncodingError;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/usercentrics/tcf/core/encoder/Base64Url;", "", "()V", "Companion", "usercentrics_release"})
public final class Base64Url {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DICT = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_";
    @NotNull
    private static final Lazy<Map<String, Integer>> REVERSE_DICT$delegate = LazyKt.lazy((Function0)Companion.REVERSE_DICT.2.INSTANCE);
    private static final int BASIS = 6;
    private static final int LCM = 24;

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R'\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/usercentrics/tcf/core/encoder/Base64Url$Companion;", "", "()V", "BASIS", "", "DICT", "", "LCM", "REVERSE_DICT", "", "getREVERSE_DICT", "()Ljava/util/Map;", "REVERSE_DICT$delegate", "Lkotlin/Lazy;", "decode", "str", "encode", "usercentrics_release"})
    public static final class Companion {
        private Companion() {
        }

        private final Map<String, Integer> getREVERSE_DICT() {
            Lazy lazy = REVERSE_DICT$delegate;
            return (Map)lazy.getValue();
        }

        @NotNull
        public final String encode(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            Object tempStr = str;
            Regex binaryRegex = new Regex("[0-1]+");
            int padding = ((String)tempStr).length() % 24;
            if (padding > 0) {
                tempStr = (String)tempStr + StringsKt.repeat((CharSequence)"0", (int)(24 - padding));
            }
            Object result = "";
            int i = 0;
            int n = ((String)tempStr).length() + -1;
            int n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)6);
            if (i <= n2) {
                while (true) {
                    String subString;
                    Intrinsics.checkNotNullExpressionValue((Object)((String)tempStr).substring(i, i + 6), (String)"substring(...)");
                    if (!binaryRegex.matches((CharSequence)subString)) {
                        throw new EncodingError("Invalid bitField");
                    }
                    int baseTwoInt = Integer.parseInt(subString, CharsKt.checkRadix((int)2));
                    result = (String)result + Base64Url.DICT.charAt(baseTwoInt);
                    if (i == n2) break;
                    i += 6;
                }
            }
            return result;
        }

        @NotNull
        public final String decode(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            Object result = "";
            try {
                int n = str.length();
                for (int i = 0; i < n; ++i) {
                    String strBits;
                    Integer n2 = this.getREVERSE_DICT().get(String.valueOf(str.charAt(i)));
                    if (n2 == null) {
                        throw new DecodingError("Invalid value on index " + i);
                    }
                    int fetchedChar = n2;
                    Intrinsics.checkNotNullExpressionValue((Object)Integer.toString(fetchedChar, CharsKt.checkRadix((int)2)), (String)"toString(...)");
                    result = (String)result + StringsKt.repeat((CharSequence)"0", (int)(6 - strBits.length())) + strBits;
                }
            }
            catch (Exception ex) {
                throw new DecodingError("Invalid encoded Base64URL string");
            }
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

