/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.tcf.core.encoder.field;

import com.usercentrics.tcf.core.StringOrNumber;
import com.usercentrics.tcf.core.errors.DecodingError;
import com.usercentrics.tcf.core.errors.EncodingError;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/usercentrics/tcf/core/encoder/field/IntEncoder;", "", "()V", "Companion", "usercentrics_release"})
public final class IntEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\f"}, d2={"Lcom/usercentrics/tcf/core/encoder/field/IntEncoder$Companion;", "", "()V", "decode", "", "value", "", "numBits", "", "encode", "Lcom/usercentrics/tcf/core/StringOrNumber;", "encodeLong", "usercentrics_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String encodeLong(long value, int numBits) {
            Object bitString = null;
            String string = Long.toString(value, CharsKt.checkRadix((int)2));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            bitString = string;
            if (((String)bitString).length() > numBits || value < 0L) {
                throw new EncodingError(value + " too large to encode into " + numBits);
            }
            if (((String)bitString).length() < numBits) {
                bitString = StringsKt.repeat((CharSequence)"0", (int)(numBits - ((String)bitString).length())) + (String)bitString;
            }
            return bitString;
        }

        @NotNull
        public final String encode(@NotNull StringOrNumber value, int numBits) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Object bitString = null;
            Integer internalValue = null;
            if (value instanceof StringOrNumber.String) {
                try {
                    internalValue = Integer.parseInt(((StringOrNumber.String)value).getValue());
                }
                catch (NumberFormatException nfe) {
                    throw new EncodingError("IntEncoder value: " + value);
                }
            }
            if (value instanceof StringOrNumber.Int) {
                internalValue = ((StringOrNumber.Int)value).getValue();
            }
            if (internalValue != null) {
                String string = Integer.toString(internalValue, CharsKt.checkRadix((int)2));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                bitString = string;
                if (((String)bitString).length() > numBits || internalValue < 0) {
                    throw new EncodingError(value + " too large to encode into " + numBits);
                }
                if (((String)bitString).length() < numBits) {
                    bitString = StringsKt.repeat((CharSequence)"0", (int)(numBits - ((String)bitString).length())) + (String)bitString;
                }
            } else {
                throw new EncodingError("Invalid value: " + value);
            }
            return bitString;
        }

        public final long decode(@NotNull String value, int numBits) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (numBits != value.length()) {
                throw new DecodingError("Invalid Bit Length");
            }
            return Long.parseLong(value, CharsKt.checkRadix((int)2));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

