/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.tcf.core.encoder.field;

import com.usercentrics.tcf.core.GVL;
import com.usercentrics.tcf.core.StringOrNumber;
import com.usercentrics.tcf.core.encoder.BitLength;
import com.usercentrics.tcf.core.encoder.field.BooleanEncoder;
import com.usercentrics.tcf.core.encoder.field.IntEncoder;
import com.usercentrics.tcf.core.errors.DecodingError;
import com.usercentrics.tcf.core.model.PurposeRestriction;
import com.usercentrics.tcf.core.model.PurposeRestrictionVector;
import com.usercentrics.tcf.core.model.RestrictionType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/usercentrics/tcf/core/encoder/field/PurposeRestrictionVectorEncoder;", "", "()V", "Companion", "usercentrics_release"})
public final class PurposeRestrictionVectorEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Lcom/usercentrics/tcf/core/encoder/field/PurposeRestrictionVectorEncoder$Companion;", "", "()V", "decode", "Lcom/usercentrics/tcf/core/model/PurposeRestrictionVector;", "encodedString", "", "encode", "prVector", "usercentrics_release"})
    @SourceDebugExtension(value={"SMAP\nPurposeRestrictionVectorEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PurposeRestrictionVectorEncoder.kt\ncom/usercentrics/tcf/core/encoder/field/PurposeRestrictionVectorEncoder$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n1855#2,2:156\n*S KotlinDebug\n*F\n+ 1 PurposeRestrictionVectorEncoder.kt\ncom/usercentrics/tcf/core/encoder/field/PurposeRestrictionVectorEncoder$Companion\n*L\n37#1:156,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String encode(@NotNull PurposeRestrictionVector prVector) {
            Intrinsics.checkNotNullParameter((Object)prVector, (String)"prVector");
            Object bitString = null;
            bitString = IntEncoder.Companion.encode(new StringOrNumber.Int(prVector.getNumRestrictions()), BitLength.numRestrictions.getInteger());
            GVL gvl = prVector.getGVL$usercentrics_release();
            if (prVector.isEmpty() || gvl == null) {
                return bitString;
            }
            Iterable $this$forEach$iv = prVector.getRestrictions(null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PurposeRestriction purpRestriction = (PurposeRestriction)element$iv;
                boolean bl = false;
                Integer n = purpRestriction.getPurposeId();
                Intrinsics.checkNotNull((Object)n);
                bitString = bitString + IntEncoder.Companion.encode(new StringOrNumber.Int(n), BitLength.purposeId.getInteger());
                bitString = bitString + IntEncoder.Companion.encode(new StringOrNumber.Int(purpRestriction.getRestrictionType().getValue()), BitLength.restrictionType.getInteger());
                List<Integer> vendors = prVector.getVendors(purpRestriction);
                int len = vendors.size();
                int numEntries = 0;
                int startId = 0;
                Object rangeField = "";
                for (int i = 0; i < len; ++i) {
                    int vendorId = ((Number)vendors.get(i)).intValue();
                    if (startId == 0) {
                        ++numEntries;
                        startId = vendorId;
                    }
                    if (i != len - 1 && ((Number)vendors.get(i + 1)).intValue() <= com.usercentrics.tcf.core.encoder.field.PurposeRestrictionVectorEncoder$Companion.encode$nextGvlVendor(gvl, vendorId, ((Number)vendors.get(len - 1)).intValue())) continue;
                    boolean isRange = vendorId != startId;
                    rangeField = (String)rangeField + BooleanEncoder.Companion.encode(isRange);
                    rangeField = (String)rangeField + IntEncoder.Companion.encode(new StringOrNumber.Int(startId), BitLength.vendorId.getInteger());
                    if (isRange) {
                        rangeField = (String)rangeField + IntEncoder.Companion.encode(new StringOrNumber.Int(vendorId), BitLength.vendorId.getInteger());
                    }
                    startId = 0;
                }
                bitString = bitString + IntEncoder.Companion.encode(new StringOrNumber.Int(numEntries), BitLength.numEntries.getInteger());
                bitString = bitString + (String)rangeField;
            }
            return bitString;
        }

        @NotNull
        public final PurposeRestrictionVector decode(@NotNull String encodedString) {
            Intrinsics.checkNotNullParameter((Object)encodedString, (String)"encodedString");
            int index = 0;
            PurposeRestrictionVector vector = new PurposeRestrictionVector(0, null, 3, null);
            String string = encodedString.substring(index, index + BitLength.numRestrictions.getInteger());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            int numRestrictions = (int)IntEncoder.Companion.decode(string, BitLength.numRestrictions.getInteger());
            index += BitLength.numRestrictions.getInteger();
            for (int i = 0; i < numRestrictions; ++i) {
                String string2 = encodedString.substring(index, index + BitLength.purposeId.getInteger());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                int purposeId = (int)IntEncoder.Companion.decode(string2, BitLength.purposeId.getInteger());
                String string3 = encodedString.substring(index += BitLength.purposeId.getInteger(), index + BitLength.restrictionType.getInteger());
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                int restrictionType = (int)IntEncoder.Companion.decode(string3, BitLength.restrictionType.getInteger());
                PurposeRestriction purposeRestriction = new PurposeRestriction(purposeId, RestrictionType.Companion.getRestrictionTypeByValue(restrictionType));
                String string4 = encodedString.substring(index += BitLength.restrictionType.getInteger(), index + BitLength.numEntries.getInteger());
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                int numEntries = (int)IntEncoder.Companion.decode(string4, BitLength.numEntries.getInteger());
                index += BitLength.numEntries.getInteger();
                block1: for (int j = 0; j < numEntries; ++j) {
                    String string5 = encodedString.substring(index, index + BitLength.anyBoolean.getInteger());
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                    boolean isARange = BooleanEncoder.Companion.decode(string5);
                    String string6 = encodedString.substring(index += BitLength.anyBoolean.getInteger(), index + BitLength.vendorId.getInteger());
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                    int startOrOnlyVendorId = (int)IntEncoder.Companion.decode(string6, BitLength.vendorId.getInteger());
                    index += BitLength.vendorId.getInteger();
                    if (isARange) {
                        String string7 = encodedString.substring(index, index + BitLength.vendorId.getInteger());
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                        int endVendorId = (int)IntEncoder.Companion.decode(string7, BitLength.vendorId.getInteger());
                        index += BitLength.vendorId.getInteger();
                        if (endVendorId < startOrOnlyVendorId) {
                            throw new DecodingError("Invalid RangeEntry: endVendorId " + endVendorId + " is less than " + startOrOnlyVendorId);
                        }
                        int k = startOrOnlyVendorId;
                        if (k > endVendorId) continue;
                        while (true) {
                            vector.add(k, purposeRestriction);
                            if (k == endVendorId) continue block1;
                            ++k;
                        }
                    }
                    vector.add(startOrOnlyVendorId, purposeRestriction);
                }
            }
            vector.setBitLength(index);
            return vector;
        }

        private static final int encode$nextGvlVendor(GVL gvl, int vendorId, int lastVendorId) {
            for (int nextId = vendorId + 1; nextId <= lastVendorId; ++nextId) {
                List<Integer> list = gvl.getVendorIds();
                boolean bl = list != null ? list.contains(nextId) : false;
                if (!bl) continue;
                return nextId;
            }
            return vendorId;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

