/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.ui.components;

import android.content.Context;
import android.content.res.ColorStateList;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.style.ClickableSpan;
import android.text.style.URLSpan;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.AttrRes;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.core.text.HtmlCompat;
import com.usercentrics.sdk.models.settings.PredefinedUIHtmlLinkType;
import com.usercentrics.sdk.ui.theme.UCThemeData;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0016\u0018\u0000 /2\u00020\u0001:\u0003/01B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J3\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\f0\u0018H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002J3\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\f0\u0018\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010 \u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001eJ\"\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020\u00162\b\b\u0002\u0010%\u001a\u00020\u0016J\u000e\u0010&\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#J\u000e\u0010'\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#J6\u0010(\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u0010)\u001a\u00020\u00162\b\b\u0002\u0010$\u001a\u00020\u00162\b\b\u0002\u0010*\u001a\u00020\u00162\b\b\u0002\u0010%\u001a\u00020\u0016J\u000e\u0010+\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#J\u000e\u0010,\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#J\u000e\u0010-\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#J\u000e\u0010.\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#\u00a8\u00062"}, d2={"Lcom/usercentrics/sdk/ui/components/UCTextView;", "Landroidx/appcompat/widget/AppCompatTextView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "interceptLink", "", "spannableString", "Landroid/text/SpannableString;", "targetSpan", "Landroid/text/style/URLSpan;", "replacement", "Landroid/text/style/ClickableSpan;", "processHtml", "", "underlineLink", "", "predefinedUILinkHandler", "Lkotlin/Function1;", "Lcom/usercentrics/sdk/models/settings/PredefinedUIHtmlLinkType;", "(Landroid/text/SpannableString;Ljava/lang/Boolean;Lkotlin/jvm/functions/Function1;)Ljava/lang/CharSequence;", "processHtmlWithNoLinks", "setHtmlText", "htmlText", "", "(Ljava/lang/String;Ljava/lang/Boolean;Lkotlin/jvm/functions/Function1;)V", "setHtmlTextWithNoLinks", "styleBody", "theme", "Lcom/usercentrics/sdk/ui/theme/UCThemeData;", "isBold", "isLink", "styleSectionTitle", "styleSelectedTab", "styleSmall", "isUnderline", "isSecondary", "styleTab", "styleTiny", "styleTitle", "styleUnselectedTab", "Companion", "ExternalLinkSpan", "PredefinedUILinkSpan", "usercentrics-ui_release"})
@SourceDebugExtension(value={"SMAP\nUCTextView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UCTextView.kt\ncom/usercentrics/sdk/ui/components/UCTextView\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n13579#2,2:203\n13579#2,2:205\n1#3:207\n*S KotlinDebug\n*F\n+ 1 UCTextView.kt\ncom/usercentrics/sdk/ui/components/UCTextView\n*L\n53#1:203,2\n66#1:205,2\n*E\n"})
public class UCTextView
extends AppCompatTextView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final boolean defaultUnderlineLink = true;

    public UCTextView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null);
    }

    public UCTextView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0);
    }

    public UCTextView(@NotNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
    }

    public final void setHtmlText(@NotNull String htmlText, @Nullable Boolean underlineLink, @NotNull Function1<? super PredefinedUIHtmlLinkType, Unit> predefinedUILinkHandler) {
        Intrinsics.checkNotNullParameter((Object)htmlText, (String)"htmlText");
        Intrinsics.checkNotNullParameter(predefinedUILinkHandler, (String)"predefinedUILinkHandler");
        Spanned spanned = HtmlCompat.fromHtml((String)htmlText, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)spanned, (String)"fromHtml(htmlText, HtmlC\u2026at.FROM_HTML_MODE_LEGACY)");
        Spanned spannedHtml = spanned;
        SpannableString spannableString = new SpannableString((CharSequence)spannedHtml);
        this.setText(this.processHtml(spannableString, underlineLink, predefinedUILinkHandler));
    }

    public static /* synthetic */ void setHtmlText$default(UCTextView uCTextView, String string, Boolean bl, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setHtmlText");
        }
        if ((n & 2) != 0) {
            bl = null;
        }
        uCTextView.setHtmlText(string, bl, (Function1<? super PredefinedUIHtmlLinkType, Unit>)function1);
    }

    public final void setHtmlTextWithNoLinks(@NotNull String htmlText) {
        Intrinsics.checkNotNullParameter((Object)htmlText, (String)"htmlText");
        Spanned spanned = HtmlCompat.fromHtml((String)htmlText, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)spanned, (String)"fromHtml(htmlText, HtmlC\u2026at.FROM_HTML_MODE_LEGACY)");
        Spanned spannedHtml = spanned;
        SpannableString spannableString = new SpannableString((CharSequence)spannedHtml);
        this.setText(this.processHtmlWithNoLinks(spannableString));
    }

    private final CharSequence processHtmlWithNoLinks(SpannableString spannableString) {
        URLSpan[] urlSpans = (URLSpan[])spannableString.getSpans(0, spannableString.length(), URLSpan.class);
        Intrinsics.checkNotNullExpressionValue((Object)urlSpans, (String)"urlSpans");
        URLSpan[] $this$forEach$iv = urlSpans;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            URLSpan element$iv;
            URLSpan it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            spannableString.removeSpan((Object)it);
        }
        return (CharSequence)spannableString;
    }

    private final CharSequence processHtml(SpannableString spannableString, Boolean underlineLink, Function1<? super PredefinedUIHtmlLinkType, Unit> predefinedUILinkHandler) {
        Boolean bl = underlineLink;
        boolean isUnderlineText = bl != null ? bl : true;
        URLSpan[] urlSpans = (URLSpan[])spannableString.getSpans(0, spannableString.length(), URLSpan.class);
        Intrinsics.checkNotNullExpressionValue((Object)urlSpans, (String)"urlSpans");
        URLSpan[] $this$forEach$iv = urlSpans;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            ClickableSpan clickableSpan;
            PredefinedUIHtmlLinkType linkType;
            URLSpan element$iv;
            URLSpan it = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            String string = it.getURL();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.url");
            PredefinedUIHtmlLinkType predefinedUIHtmlLinkType = linkType = PredefinedUIHtmlLinkType.Companion.from(string);
            switch (predefinedUIHtmlLinkType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[predefinedUIHtmlLinkType.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    clickableSpan = new PredefinedUILinkSpan(linkType, predefinedUILinkHandler, isUnderlineText);
                    break;
                }
                case -1: {
                    String string2 = it.getURL();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.url");
                    clickableSpan = (ClickableSpan)new ExternalLinkSpan(string2, isUnderlineText);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            ClickableSpan replacement = clickableSpan;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.interceptLink(spannableString, it, replacement);
        }
        return (CharSequence)spannableString;
    }

    private final void interceptLink(SpannableString spannableString, URLSpan targetSpan, ClickableSpan replacement) {
        int start = spannableString.getSpanStart((Object)targetSpan);
        int end = spannableString.getSpanEnd((Object)targetSpan);
        spannableString.removeSpan((Object)targetSpan);
        spannableString.setSpan((Object)replacement, start, end, 33);
    }

    public final void styleTitle(@NotNull UCThemeData theme) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.setTypeface(theme.getFonts().getFont(), 1);
        Integer n = theme.getColorPalette().getText100();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.setTextColor(it);
        }
        this.setTextSize(2, theme.getFonts().getSizes().getTitle());
        this.setPaintFlags(1);
    }

    public final void styleBody(@NotNull UCThemeData theme, boolean isBold, boolean isLink) {
        int it;
        Integer n;
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        if (isBold) {
            this.setTypeface(theme.getFonts().getFont(), 1);
        } else {
            this.setTypeface(theme.getFonts().getFont());
        }
        Integer n2 = n = isLink ? theme.getColorPalette().getLinkColor() : theme.getColorPalette().getText100();
        if (n != null) {
            it = ((Number)n).intValue();
            boolean bl = false;
            this.setTextColor(it);
        }
        Integer n3 = theme.getColorPalette().getLinkColor();
        if (n3 != null) {
            it = ((Number)n3).intValue();
            boolean bl = false;
            this.setLinkTextColor(it);
        }
        this.setTextSize(2, theme.getFonts().getSizes().getBody());
        this.setPaintFlags(1);
    }

    public static /* synthetic */ void styleBody$default(UCTextView uCTextView, UCThemeData uCThemeData, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: styleBody");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        uCTextView.styleBody(uCThemeData, bl, bl2);
    }

    public final void styleSmall(@NotNull UCThemeData theme, boolean isUnderline, boolean isBold, boolean isSecondary, boolean isLink) {
        Integer color;
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        if (isBold) {
            this.setTypeface(theme.getFonts().getFont(), 1);
        } else {
            this.setTypeface(theme.getFonts().getFont());
        }
        this.setTextSize(2, theme.getFonts().getSizes().getSmall());
        Integer n = color = isLink ? theme.getColorPalette().getLinkColor() : (isSecondary ? theme.getColorPalette().getText80() : theme.getColorPalette().getText100());
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.setTextColor(it);
        }
        this.setPaintFlags(isUnderline ? 9 : 1);
    }

    public static /* synthetic */ void styleSmall$default(UCTextView uCTextView, UCThemeData uCThemeData, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: styleSmall");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        if ((n & 0x10) != 0) {
            bl4 = false;
        }
        uCTextView.styleSmall(uCThemeData, bl, bl2, bl3, bl4);
    }

    public final void styleTiny(@NotNull UCThemeData theme) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.setTypeface(theme.getFonts().getFont());
        Integer n = theme.getColorPalette().getText80();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.setTextColor(it);
        }
        this.setTextSize(2, theme.getFonts().getSizes().getTiny());
        this.setPaintFlags(1);
    }

    public final void styleTab(@NotNull UCThemeData theme) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[]{0x10100A1};
        nArrayArray[0] = nArray;
        nArray = new int[]{-16842913};
        nArrayArray[1] = nArray;
        int[][] states = nArrayArray;
        if (theme.getColorPalette().getSelectedTabColor() != null && theme.getColorPalette().getText100() != null) {
            nArray = new int[]{theme.getColorPalette().getSelectedTabColor(), theme.getColorPalette().getText100()};
            int[] colors = nArray;
            ColorStateList colorList = new ColorStateList((int[][])states, colors);
            this.setTextColor(colorList);
        }
        this.setAllCaps(false);
        this.setGravity(1);
        this.setTypeface(theme.getFonts().getFont());
        this.setTextSize(2, theme.getFonts().getSizes().getBody());
    }

    public final void styleSelectedTab(@NotNull UCThemeData theme) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.setTypeface(theme.getFonts().getFont(), 1);
    }

    public final void styleUnselectedTab(@NotNull UCThemeData theme) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.setTypeface(theme.getFonts().getFont());
    }

    public final void styleSectionTitle(@NotNull UCThemeData theme) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.setTypeface(theme.getFonts().getFont(), 1);
        this.setTextSize(2, theme.getFonts().getSizes().getBody());
        Integer n = theme.getColorPalette().getText100();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.setTextColor(it);
        }
        this.setPaintFlags(1);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PredefinedUIHtmlLinkType.values().length];
            try {
                nArray[PredefinedUIHtmlLinkType.ACCEPT_ALL_LINK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PredefinedUIHtmlLinkType.DENY_ALL_LINK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PredefinedUIHtmlLinkType.SHOW_SECOND_LAYER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/usercentrics/sdk/ui/components/UCTextView$PredefinedUILinkSpan;", "Landroid/text/style/ClickableSpan;", "link", "Lcom/usercentrics/sdk/models/settings/PredefinedUIHtmlLinkType;", "handler", "Lkotlin/Function1;", "", "isUnderlineText", "", "(Lcom/usercentrics/sdk/models/settings/PredefinedUIHtmlLinkType;Lkotlin/jvm/functions/Function1;Z)V", "onClick", "widget", "Landroid/view/View;", "updateDrawState", "ds", "Landroid/text/TextPaint;", "usercentrics-ui_release"})
    private static final class PredefinedUILinkSpan
    extends ClickableSpan {
        @NotNull
        private final PredefinedUIHtmlLinkType link;
        @NotNull
        private final Function1<PredefinedUIHtmlLinkType, Unit> handler;
        private final boolean isUnderlineText;

        public PredefinedUILinkSpan(@NotNull PredefinedUIHtmlLinkType link, @NotNull Function1<? super PredefinedUIHtmlLinkType, Unit> handler, boolean isUnderlineText) {
            Intrinsics.checkNotNullParameter((Object)link, (String)"link");
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            this.link = link;
            this.handler = handler;
            this.isUnderlineText = isUnderlineText;
        }

        public void onClick(@NotNull View widget) {
            Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
            this.handler.invoke((Object)this.link);
        }

        public void updateDrawState(@NotNull TextPaint ds) {
            Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
            super.updateDrawState(ds);
            ds.setUnderlineText(this.isUnderlineText);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/usercentrics/sdk/ui/components/UCTextView$ExternalLinkSpan;", "Landroid/text/style/URLSpan;", "url", "", "isUnderlineText", "", "(Ljava/lang/String;Z)V", "updateDrawState", "", "ds", "Landroid/text/TextPaint;", "usercentrics-ui_release"})
    private static final class ExternalLinkSpan
    extends URLSpan {
        private final boolean isUnderlineText;

        public ExternalLinkSpan(@NotNull String url, boolean isUnderlineText) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            super(url);
            this.isUnderlineText = isUnderlineText;
        }

        public void updateDrawState(@NotNull TextPaint ds) {
            Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
            super.updateDrawState(ds);
            ds.setUnderlineText(this.isUnderlineText);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/usercentrics/sdk/ui/components/UCTextView$Companion;", "", "()V", "defaultUnderlineLink", "", "usercentrics-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

