/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.ui.components.cookie;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.usercentrics.sdk.models.settings.PredefinedUIDeviceStorageContent;
import com.usercentrics.sdk.ui.R;
import com.usercentrics.sdk.ui.components.UCImageView;
import com.usercentrics.sdk.ui.components.UCTextView;
import com.usercentrics.sdk.ui.components.cookie.CookieInformationAdapter;
import com.usercentrics.sdk.ui.components.cookie.UCCookiesViewModel;
import com.usercentrics.sdk.ui.components.drawable.ThemedDrawable;
import com.usercentrics.sdk.ui.extensions.ContextExtensionsKt;
import com.usercentrics.sdk.ui.extensions.NumberExtensionsKt;
import com.usercentrics.sdk.ui.theme.UCThemeData;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020+H\u0002J\b\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u00020+H\u0002J\b\u00100\u001a\u00020+H\u0002J\b\u00101\u001a\u00020+H\u0002J\u0016\u00102\u001a\u00020+2\f\u00103\u001a\b\u0012\u0004\u0012\u00020504H\u0002J\b\u00106\u001a\u00020+H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000e\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u000e\u001a\u0004\b\u001b\u0010\u001cR\u001b\u0010\u001e\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u000e\u001a\u0004\b\u001f\u0010\u0017R\u001b\u0010!\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u000e\u001a\u0004\b\"\u0010\u001cR\u001b\u0010$\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u000e\u001a\u0004\b%\u0010\u0017R\u001b\u0010'\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u000e\u001a\u0004\b(\u0010\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/usercentrics/sdk/ui/components/cookie/UCCookiesView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "theme", "Lcom/usercentrics/sdk/ui/theme/UCThemeData;", "viewModel", "Lcom/usercentrics/sdk/ui/components/cookie/UCCookiesViewModel;", "(Landroid/content/Context;Lcom/usercentrics/sdk/ui/theme/UCThemeData;Lcom/usercentrics/sdk/ui/components/cookie/UCCookiesViewModel;)V", "ucCookieDialogClose", "Lcom/usercentrics/sdk/ui/components/UCImageView;", "getUcCookieDialogClose", "()Lcom/usercentrics/sdk/ui/components/UCImageView;", "ucCookieDialogClose$delegate", "Lkotlin/Lazy;", "ucCookieDialogList", "Landroidx/recyclerview/widget/RecyclerView;", "getUcCookieDialogList", "()Landroidx/recyclerview/widget/RecyclerView;", "ucCookieDialogList$delegate", "ucCookieDialogTitle", "Lcom/usercentrics/sdk/ui/components/UCTextView;", "getUcCookieDialogTitle", "()Lcom/usercentrics/sdk/ui/components/UCTextView;", "ucCookieDialogTitle$delegate", "ucCookieLoadingBox", "Landroid/widget/LinearLayout;", "getUcCookieLoadingBox", "()Landroid/widget/LinearLayout;", "ucCookieLoadingBox$delegate", "ucCookieLoadingText", "getUcCookieLoadingText", "ucCookieLoadingText$delegate", "ucCookieRetryBox", "getUcCookieRetryBox", "ucCookieRetryBox$delegate", "ucCookieRetryMessage", "getUcCookieRetryMessage", "ucCookieRetryMessage$delegate", "ucCookieTryAgainBtn", "getUcCookieTryAgainBtn", "ucCookieTryAgainBtn$delegate", "applyTheme", "", "bindContent", "cookieInformationBoxBackground", "Landroid/graphics/drawable/GradientDrawable;", "inflateView", "loadInformation", "setPadding", "showCookieInfo", "data", "", "Lcom/usercentrics/sdk/models/settings/PredefinedUIDeviceStorageContent;", "showRetry", "usercentrics-ui_release"})
@SuppressLint(value={"ViewConstructor"})
@SourceDebugExtension(value={"SMAP\nUCCookiesView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UCCookiesView.kt\ncom/usercentrics/sdk/ui/components/cookie/UCCookiesView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1#2:122\n*E\n"})
public final class UCCookiesView
extends ConstraintLayout {
    @NotNull
    private final UCThemeData theme;
    @NotNull
    private final UCCookiesViewModel viewModel;
    @NotNull
    private final Lazy ucCookieDialogTitle$delegate;
    @NotNull
    private final Lazy ucCookieLoadingText$delegate;
    @NotNull
    private final Lazy ucCookieTryAgainBtn$delegate;
    @NotNull
    private final Lazy ucCookieRetryMessage$delegate;
    @NotNull
    private final Lazy ucCookieLoadingBox$delegate;
    @NotNull
    private final Lazy ucCookieRetryBox$delegate;
    @NotNull
    private final Lazy ucCookieDialogList$delegate;
    @NotNull
    private final Lazy ucCookieDialogClose$delegate;

    public UCCookiesView(@NotNull Context context, @NotNull UCThemeData theme, @NotNull UCCookiesViewModel viewModel) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        super(context);
        this.theme = theme;
        this.viewModel = viewModel;
        this.ucCookieDialogTitle$delegate = LazyKt.lazy((Function0)((Function0)new Function0<UCTextView>(this){
            final /* synthetic */ UCCookiesView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final UCTextView invoke() {
                return (UCTextView)this.this$0.findViewById(R.id.ucCookieDialogTitle);
            }
        }));
        this.ucCookieLoadingText$delegate = LazyKt.lazy((Function0)((Function0)new Function0<UCTextView>(this){
            final /* synthetic */ UCCookiesView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final UCTextView invoke() {
                return (UCTextView)this.this$0.findViewById(R.id.ucCookieLoadingText);
            }
        }));
        this.ucCookieTryAgainBtn$delegate = LazyKt.lazy((Function0)((Function0)new Function0<UCTextView>(this){
            final /* synthetic */ UCCookiesView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final UCTextView invoke() {
                return (UCTextView)this.this$0.findViewById(R.id.ucCookieTryAgainBtn);
            }
        }));
        this.ucCookieRetryMessage$delegate = LazyKt.lazy((Function0)((Function0)new Function0<UCTextView>(this){
            final /* synthetic */ UCCookiesView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final UCTextView invoke() {
                return (UCTextView)this.this$0.findViewById(R.id.ucCookieRetryMessage);
            }
        }));
        this.ucCookieLoadingBox$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LinearLayout>(this){
            final /* synthetic */ UCCookiesView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final LinearLayout invoke() {
                return (LinearLayout)this.this$0.findViewById(R.id.ucCookieLoadingBox);
            }
        }));
        this.ucCookieRetryBox$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LinearLayout>(this){
            final /* synthetic */ UCCookiesView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final LinearLayout invoke() {
                return (LinearLayout)this.this$0.findViewById(R.id.ucCookieRetryBox);
            }
        }));
        this.ucCookieDialogList$delegate = LazyKt.lazy((Function0)((Function0)new Function0<RecyclerView>(this){
            final /* synthetic */ UCCookiesView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final RecyclerView invoke() {
                return (RecyclerView)this.this$0.findViewById(R.id.ucCookieDialogList);
            }
        }));
        this.ucCookieDialogClose$delegate = LazyKt.lazy((Function0)((Function0)new Function0<UCImageView>(this){
            final /* synthetic */ UCCookiesView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final UCImageView invoke() {
                return (UCImageView)this.this$0.findViewById(R.id.ucCookieDialogClose);
            }
        }));
        this.setPadding();
        this.inflateView();
        this.applyTheme();
        this.bindContent();
    }

    private final UCTextView getUcCookieDialogTitle() {
        Lazy lazy = this.ucCookieDialogTitle$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-ucCookieDialogTitle>(...)");
        return (UCTextView)((Object)object);
    }

    private final UCTextView getUcCookieLoadingText() {
        Lazy lazy = this.ucCookieLoadingText$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-ucCookieLoadingText>(...)");
        return (UCTextView)((Object)object);
    }

    private final UCTextView getUcCookieTryAgainBtn() {
        Lazy lazy = this.ucCookieTryAgainBtn$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-ucCookieTryAgainBtn>(...)");
        return (UCTextView)((Object)object);
    }

    private final UCTextView getUcCookieRetryMessage() {
        Lazy lazy = this.ucCookieRetryMessage$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-ucCookieRetryMessage>(...)");
        return (UCTextView)((Object)object);
    }

    private final LinearLayout getUcCookieLoadingBox() {
        Lazy lazy = this.ucCookieLoadingBox$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-ucCookieLoadingBox>(...)");
        return (LinearLayout)object;
    }

    private final LinearLayout getUcCookieRetryBox() {
        Lazy lazy = this.ucCookieRetryBox$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-ucCookieRetryBox>(...)");
        return (LinearLayout)object;
    }

    private final RecyclerView getUcCookieDialogList() {
        Lazy lazy = this.ucCookieDialogList$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-ucCookieDialogList>(...)");
        return (RecyclerView)object;
    }

    private final UCImageView getUcCookieDialogClose() {
        Lazy lazy = this.ucCookieDialogClose$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-ucCookieDialogClose>(...)");
        return (UCImageView)((Object)object);
    }

    private final void setPadding() {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        int padding = NumberExtensionsKt.dpToPx(12, context);
        this.setPadding(padding, padding, padding, padding);
    }

    private final void inflateView() {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        ContextExtensionsKt.getInflater(context).inflate(R.layout.uc_cookie_dialog, (ViewGroup)this);
    }

    private final void applyTheme() {
        Drawable drawable2;
        UCTextView.styleBody$default(this.getUcCookieDialogTitle(), this.theme, true, false, 4, null);
        UCTextView.styleBody$default(this.getUcCookieLoadingText(), this.theme, false, false, 6, null);
        UCTextView.styleBody$default(this.getUcCookieTryAgainBtn(), this.theme, false, true, 2, null);
        UCTextView.styleBody$default(this.getUcCookieRetryMessage(), this.theme, false, false, 6, null);
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        Drawable drawable3 = ThemedDrawable.INSTANCE.getCloseIcon(context);
        if (drawable3 != null) {
            Drawable drawable4;
            Drawable it = drawable4 = drawable3;
            boolean bl = false;
            ThemedDrawable.INSTANCE.styleIcon(it, this.theme);
            drawable2 = drawable4;
        } else {
            drawable2 = null;
        }
        Drawable icon = drawable2;
        this.getUcCookieDialogClose().setImageDrawable(icon);
        Integer n = this.theme.getColorPalette().getLayerBackgroundSecondaryColor();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.setBackgroundColor(it);
        }
        this.getUcCookieRetryBox().setBackground((Drawable)this.cookieInformationBoxBackground());
        this.getUcCookieLoadingBox().setBackground((Drawable)this.cookieInformationBoxBackground());
    }

    private final GradientDrawable cookieInformationBoxBackground() {
        GradientDrawable gradientDrawable;
        GradientDrawable $this$cookieInformationBoxBackground_u24lambda_u242 = gradientDrawable = new GradientDrawable();
        boolean bl = false;
        $this$cookieInformationBoxBackground_u24lambda_u242.setShape(0);
        Integer n = this.theme.getColorPalette().getLayerBackgroundSecondaryColor();
        $this$cookieInformationBoxBackground_u24lambda_u242.setColor(n != null ? n : -1);
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        $this$cookieInformationBoxBackground_u24lambda_u242.setStroke(NumberExtensionsKt.dpToPx(1, context), this.theme.getColorPalette().getTabsBorderColor());
        return gradientDrawable;
    }

    private final void bindContent() {
        this.getUcCookieDialogTitle().setText(this.viewModel.getTitleDetailed());
        this.getUcCookieLoadingText().setText(this.viewModel.getLoading());
        this.getUcCookieRetryMessage().setText(this.viewModel.getError());
        this.getUcCookieTryAgainBtn().setText(this.viewModel.getTryAgain());
        this.getUcCookieDialogClose().setOnClickListener(arg_0 -> UCCookiesView.bindContent$lambda$3(this, arg_0));
        this.loadInformation();
    }

    private final void loadInformation() {
        this.getUcCookieLoadingBox().setVisibility(0);
        this.getUcCookieRetryBox().setVisibility(8);
        this.getUcCookieDialogList().setVisibility(8);
        this.viewModel.loadInformation((Function1<? super List<PredefinedUIDeviceStorageContent>, Unit>)((Function1)new Function1<List<? extends PredefinedUIDeviceStorageContent>, Unit>(this){
            final /* synthetic */ UCCookiesView this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull List<PredefinedUIDeviceStorageContent> disclosures) {
                Intrinsics.checkNotNullParameter(disclosures, (String)"disclosures");
                UCCookiesView.access$showCookieInfo(this.this$0, disclosures);
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ UCCookiesView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                UCCookiesView.access$showRetry(this.this$0);
            }
        }));
    }

    private final void showRetry() {
        this.getUcCookieLoadingBox().setVisibility(8);
        this.getUcCookieDialogList().setVisibility(8);
        this.getUcCookieRetryBox().setVisibility(0);
        this.getUcCookieTryAgainBtn().setOnClickListener(arg_0 -> UCCookiesView.showRetry$lambda$4(this, arg_0));
    }

    private final void showCookieInfo(List<PredefinedUIDeviceStorageContent> data) {
        this.getUcCookieLoadingBox().setVisibility(8);
        this.getUcCookieRetryBox().setVisibility(8);
        this.getUcCookieDialogList().setVisibility(0);
        CookieInformationAdapter listAdapter = new CookieInformationAdapter(this.theme, data);
        this.getUcCookieDialogList().setAdapter((RecyclerView.Adapter)listAdapter);
        this.getUcCookieDialogList().setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
    }

    private static final void bindContent$lambda$3(UCCookiesView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.viewModel.onDismiss();
    }

    private static final void showRetry$lambda$4(UCCookiesView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.loadInformation();
    }

    public static final /* synthetic */ void access$showCookieInfo(UCCookiesView $this, List data) {
        $this.showCookieInfo(data);
    }

    public static final /* synthetic */ void access$showRetry(UCCookiesView $this) {
        $this.showRetry();
    }
}

