/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.ui.banner;

import android.animation.LayoutTransition;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import androidx.annotation.ColorInt;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.core.view.ViewGroupKt;
import com.usercentrics.sdk.PopupPosition;
import com.usercentrics.sdk.UsercentricsLayout;
import com.usercentrics.sdk.ui.R;
import com.usercentrics.sdk.ui.banner.UCBannerContainer;
import com.usercentrics.sdk.ui.extensions.NumberExtensionsKt;
import com.usercentrics.sdk.ui.firstLayer.UCFirstLayerView;
import com.usercentrics.sdk.ui.firstLayer.UCFirstLayerViewModel;
import com.usercentrics.sdk.ui.layerView.CancelLogoDownloadKt;
import com.usercentrics.sdk.ui.secondLayer.UCSecondLayerView;
import com.usercentrics.sdk.ui.secondLayer.UCSecondLayerViewModel;
import com.usercentrics.sdk.ui.theme.UCThemeData;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ\u0017\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u000bH\u0016J1\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0019H\u0016J!\u0010\u001a\u001a\u00020\u000b2\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0019\u0010\u001f\u001a\u00020\u000b2\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ3\u0010 \u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010!\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010\"J)\u0010#\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020$2\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010%R\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&\u00b2\u0006\n\u0010'\u001a\u00020\rX\u008a\u0084\u0002"}, d2={"Lcom/usercentrics/sdk/ui/banner/UCBannerContainerView;", "Landroid/widget/FrameLayout;", "Lcom/usercentrics/sdk/ui/banner/UCBannerContainer;", "context", "Landroid/content/Context;", "theme", "Lcom/usercentrics/sdk/ui/theme/UCThemeData;", "themedContext", "(Landroid/content/Context;Lcom/usercentrics/sdk/ui/theme/UCThemeData;Landroid/content/Context;)V", "contentView", "applyStatusBarColor", "", "color", "", "(Ljava/lang/Integer;)V", "cancelLogoDownload", "showFirstLayer", "viewModel", "Lcom/usercentrics/sdk/ui/firstLayer/UCFirstLayerViewModel;", "layout", "Lcom/usercentrics/sdk/UsercentricsLayout;", "customBackgroundColor", "customCornerRadiusInDp", "(Lcom/usercentrics/sdk/ui/firstLayer/UCFirstLayerViewModel;Lcom/usercentrics/sdk/UsercentricsLayout;Ljava/lang/Integer;Ljava/lang/Integer;)V", "showSecondLayer", "Lcom/usercentrics/sdk/ui/secondLayer/UCSecondLayerViewModel;", "styleBottomSheet", "layerBackgroundColor", "cornerRadius", "", "(Ljava/lang/Integer;F)V", "styleFullScreen", "styleLayout", "statusBarColor", "(Lcom/usercentrics/sdk/UsercentricsLayout;Ljava/lang/Integer;FLjava/lang/Integer;)V", "stylePopup", "Lcom/usercentrics/sdk/UsercentricsLayout$Popup;", "(Lcom/usercentrics/sdk/UsercentricsLayout$Popup;Ljava/lang/Integer;F)V", "usercentrics-ui_release", "defaultMargin"})
@SuppressLint(value={"ViewConstructor"})
@SourceDebugExtension(value={"SMAP\nUCBannerContainerView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UCBannerContainerView.kt\ncom/usercentrics/sdk/ui/banner/UCBannerContainerView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1#2:142\n*E\n"})
public final class UCBannerContainerView
extends FrameLayout
implements UCBannerContainer {
    @NotNull
    private final Context context;
    @NotNull
    private final UCThemeData theme;
    @NotNull
    private final Context themedContext;
    @NotNull
    private final FrameLayout contentView;

    /*
     * WARNING - void declaration
     */
    public UCBannerContainerView(@NotNull Context context, @NotNull UCThemeData theme, @NotNull Context themedContext) {
        void $this$contentView_u24lambda_u241_u24lambda_u240;
        void it;
        LayoutTransition layoutTransition;
        FrameLayout frameLayout;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        Intrinsics.checkNotNullParameter((Object)themedContext, (String)"themedContext");
        super(themedContext);
        this.context = context;
        this.theme = theme;
        this.themedContext = themedContext;
        FrameLayout frameLayout2 = frameLayout = new FrameLayout(this.themedContext);
        UCBannerContainerView uCBannerContainerView = this;
        boolean bl = false;
        LayoutTransition layoutTransition2 = layoutTransition = new LayoutTransition();
        void var9_10 = it;
        boolean bl2 = false;
        $this$contentView_u24lambda_u241_u24lambda_u240.enableTransitionType(7);
        var9_10.setLayoutTransition(layoutTransition);
        this.addView((View)it);
        uCBannerContainerView.contentView = frameLayout;
    }

    @Override
    public void showFirstLayer(@NotNull UCFirstLayerViewModel viewModel, @NotNull UsercentricsLayout layout, @Nullable Integer customBackgroundColor, @Nullable Integer customCornerRadiusInDp) {
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        Integer n = customCornerRadiusInDp;
        float cornerRadius = NumberExtensionsKt.dpToPx((float)(n != null ? n.intValue() : this.theme.getBannerCornerRadius()), this.themedContext);
        Integer n2 = customBackgroundColor;
        if (n2 == null) {
            n2 = this.theme.getColorPalette().getLayerBackgroundColor();
        }
        this.styleLayout(layout, n2, cornerRadius, viewModel.getStatusBarColor());
        this.contentView.removeAllViews();
        UCFirstLayerView firstLayerView = new UCFirstLayerView(this.themedContext, this.theme, cornerRadius, viewModel);
        this.contentView.addView((View)firstLayerView);
    }

    @Override
    public void showSecondLayer(@NotNull UCSecondLayerViewModel viewModel) {
        UCSecondLayerView uCSecondLayerView;
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        this.styleFullScreen(this.theme.getColorPalette().getLayerBackgroundColor());
        this.applyStatusBarColor(viewModel.getStatusBarColor());
        this.contentView.removeAllViews();
        UCSecondLayerView it = uCSecondLayerView = new UCSecondLayerView(this.themedContext, this.theme);
        boolean bl = false;
        it.bindViewModel(viewModel);
        UCSecondLayerView secondLayerView = uCSecondLayerView;
        this.contentView.addView((View)secondLayerView);
    }

    @Override
    public void cancelLogoDownload() {
        View view = (View)SequencesKt.first((Sequence)ViewGroupKt.getChildren((ViewGroup)((ViewGroup)this.contentView)));
        if (view instanceof UCFirstLayerView) {
            CancelLogoDownloadKt.cancelLogoDownload((LinearLayoutCompat)view, R.id.ucFirstLayerHeaderLogo);
        } else if (view instanceof UCSecondLayerView) {
            CancelLogoDownloadKt.cancelLogoDownload((LinearLayoutCompat)view, R.id.ucHeaderLogo);
        } else if (_Assertions.ENABLED) {
            boolean bl = false;
            String string = "Unknown view type " + view.getClass() + " types possible: UCFirstLayerView, UCSecondLayerView ";
            throw new AssertionError((Object)string);
        }
    }

    private final void styleLayout(UsercentricsLayout layout2, @ColorInt Integer layerBackgroundColor, float cornerRadius, Integer statusBarColor) {
        UsercentricsLayout usercentricsLayout = layout2;
        if (usercentricsLayout instanceof UsercentricsLayout.Sheet) {
            this.styleBottomSheet(layerBackgroundColor, cornerRadius);
        } else if (usercentricsLayout instanceof UsercentricsLayout.Popup) {
            this.stylePopup((UsercentricsLayout.Popup)layout2, layerBackgroundColor, cornerRadius);
        } else if (usercentricsLayout instanceof UsercentricsLayout.Full) {
            this.styleFullScreen(layerBackgroundColor);
        }
        this.applyStatusBarColor(statusBarColor);
    }

    /*
     * WARNING - void declaration
     */
    private final void styleBottomSheet(@ColorInt Integer layerBackgroundColor, float cornerRadius) {
        void $this$styleBottomSheet_u24lambda_u247_u24lambda_u246;
        GradientDrawable $this$styleBottomSheet_u24lambda_u247_u24lambda_u245;
        GradientDrawable gradientDrawable;
        FrameLayout frameLayout;
        this.setTag(80);
        FrameLayout $this$styleBottomSheet_u24lambda_u247 = frameLayout = this.contentView;
        boolean bl = false;
        GradientDrawable gradientDrawable2 = gradientDrawable = new GradientDrawable();
        FrameLayout frameLayout2 = $this$styleBottomSheet_u24lambda_u247;
        boolean bl2 = false;
        Object[] objectArray = new Float[]{Float.valueOf(cornerRadius), Float.valueOf(cornerRadius), Float.valueOf(cornerRadius), Float.valueOf(cornerRadius), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)};
        $this$styleBottomSheet_u24lambda_u247_u24lambda_u245.setCornerRadii(CollectionsKt.toFloatArray((Collection)CollectionsKt.listOf((Object[])objectArray)));
        Integer n = layerBackgroundColor;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl3 = false;
            $this$styleBottomSheet_u24lambda_u247_u24lambda_u245.setColor(it);
        }
        frameLayout2.setBackground((Drawable)gradientDrawable);
        $this$styleBottomSheet_u24lambda_u247_u24lambda_u245 = gradientDrawable = new FrameLayout.LayoutParams(-1, -2, 80);
        frameLayout2 = $this$styleBottomSheet_u24lambda_u247;
        boolean bl4 = false;
        int topMargin = NumberExtensionsKt.dpToPx(24, this.themedContext);
        $this$styleBottomSheet_u24lambda_u247_u24lambda_u246.setMargins(0, topMargin, 0, 0);
        frameLayout2.setLayoutParams((ViewGroup.LayoutParams)gradientDrawable);
    }

    private final void styleFullScreen(@ColorInt Integer layerBackgroundColor) {
        this.setTag(-1);
        Integer n = layerBackgroundColor;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.contentView.setBackgroundColor(it);
        }
        this.contentView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    private final void applyStatusBarColor(Integer color) {
        Integer n = color;
        if (n == null) {
            return;
        }
        int statusBarColor = n;
        Context context = this.context;
        Activity activity = context instanceof Activity ? (Activity)context : null;
        Object object = activity != null ? activity.getWindow() : null;
        if (object == null) {
            return;
        }
        Window window = object;
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        window.setStatusBarColor(statusBarColor);
    }

    /*
     * WARNING - void declaration
     */
    private final void stylePopup(UsercentricsLayout.Popup layout2, @ColorInt Integer layerBackgroundColor, float cornerRadius) {
        void $this$stylePopup_u24lambda_u2412;
        FrameLayout.LayoutParams layoutParams;
        int n;
        GradientDrawable gradientDrawable;
        GradientDrawable $this$stylePopup_u24lambda_u2410 = gradientDrawable = new GradientDrawable();
        boolean $i$a$-apply-UCBannerContainerView$stylePopup$gradientDrawable$22 = false;
        $this$stylePopup_u24lambda_u2410.setCornerRadius(cornerRadius);
        Integer n2 = layerBackgroundColor;
        if (n2 != null) {
            int it = ((Number)n2).intValue();
            boolean bl = false;
            $this$stylePopup_u24lambda_u2410.setColor(it);
        }
        GradientDrawable gradientDrawable2 = gradientDrawable;
        this.contentView.setBackground((Drawable)gradientDrawable2);
        switch (WhenMappings.$EnumSwitchMapping$0[layout2.getPosition().ordinal()]) {
            case 1: {
                n = 80;
                break;
            }
            case 2: {
                n = 17;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int gravity = n;
        this.setTag(gravity);
        FrameLayout.LayoutParams $i$a$-apply-UCBannerContainerView$stylePopup$gradientDrawable$22 = layoutParams = new FrameLayout.LayoutParams(-1, -2, gravity);
        FrameLayout frameLayout = this.contentView;
        boolean bl = false;
        Lazy defaultMargin$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ UCBannerContainerView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return this.this$0.getResources().getDimensionPixelOffset(R.dimen.ucFirstLayerPopupMargin);
            }
        }));
        Float f = layout2.getHorizontalMarginInDp();
        int horizontalMargin = f != null ? (int)NumberExtensionsKt.dpToPx(f.floatValue(), this.themedContext) : UCBannerContainerView.stylePopup$lambda$12$lambda$11((Lazy<Integer>)defaultMargin$delegate);
        Float f2 = layout2.getVerticalMarginInDp();
        int verticalMargin = f2 != null ? (int)NumberExtensionsKt.dpToPx(f2.floatValue(), this.themedContext) : UCBannerContainerView.stylePopup$lambda$12$lambda$11((Lazy<Integer>)defaultMargin$delegate);
        $this$stylePopup_u24lambda_u2412.setMargins(horizontalMargin, verticalMargin, horizontalMargin, verticalMargin);
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private static final int stylePopup$lambda$12$lambda$11(Lazy<Integer> $defaultMargin$delegate) {
        Lazy<Integer> lazy = $defaultMargin$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PopupPosition.values().length];
            try {
                nArray[PopupPosition.BOTTOM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PopupPosition.CENTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

