/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.ui.components;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.AttrRes;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.usercentrics.sdk.ui.R;
import com.usercentrics.sdk.ui.components.UCButtonSettings;
import com.usercentrics.sdk.ui.components.UCImageView;
import com.usercentrics.sdk.ui.components.UCTextView;
import com.usercentrics.sdk.ui.extensions.NumberExtensionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\tH\u0002J\u001c\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0'R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R#\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0018\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006("}, d2={"Lcom/usercentrics/sdk/ui/components/UCButton;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "value", "", "text", "getText", "()Ljava/lang/CharSequence;", "setText", "(Ljava/lang/CharSequence;)V", "ucButtonBackground", "Lcom/usercentrics/sdk/ui/components/UCImageView;", "kotlin.jvm.PlatformType", "getUcButtonBackground", "()Lcom/usercentrics/sdk/ui/components/UCImageView;", "ucButtonBackground$delegate", "Lkotlin/Lazy;", "ucButtonText", "Lcom/usercentrics/sdk/ui/components/UCTextView;", "getUcButtonText", "()Lcom/usercentrics/sdk/ui/components/UCTextView;", "ucButtonText$delegate", "initLayout", "", "setCustomBackground", "color", "cornerRadius", "setup", "settings", "Lcom/usercentrics/sdk/ui/components/UCButtonSettings;", "onClick", "Lkotlin/Function0;", "usercentrics-ui_release"})
public final class UCButton
extends ConstraintLayout {
    @NotNull
    private final Lazy ucButtonBackground$delegate;
    @NotNull
    private final Lazy ucButtonText$delegate;

    private final UCImageView getUcButtonBackground() {
        Lazy lazy = this.ucButtonBackground$delegate;
        return (UCImageView)((Object)lazy.getValue());
    }

    private final UCTextView getUcButtonText() {
        Lazy lazy = this.ucButtonText$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-ucButtonText>(...)");
        return (UCTextView)((Object)object);
    }

    @NotNull
    public final CharSequence getText() {
        CharSequence charSequence = this.getUcButtonText().getText();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"ucButtonText.text");
        return charSequence;
    }

    public final void setText(@NotNull CharSequence value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.getUcButtonText().setText(value);
    }

    public UCButton(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null);
    }

    public UCButton(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0);
    }

    public UCButton(@NotNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.ucButtonBackground$delegate = LazyKt.lazy((Function0)((Function0)new Function0<UCImageView>(this){
            final /* synthetic */ UCButton this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final UCImageView invoke() {
                return (UCImageView)this.this$0.findViewById(R.id.ucButtonBackground);
            }
        }));
        this.ucButtonText$delegate = LazyKt.lazy((Function0)((Function0)new Function0<UCTextView>(this){
            final /* synthetic */ UCButton this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final UCTextView invoke() {
                return (UCTextView)this.this$0.findViewById(R.id.ucButtonText);
            }
        }));
        this.initLayout();
    }

    private final void initLayout() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.uc_button, (ViewGroup)this);
    }

    public final void setup(@NotNull UCButtonSettings settings, @NotNull Function0<Unit> onClick) {
        UCTextView uCTextView;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter(onClick, (String)"onClick");
        this.setText(settings.getLabel());
        this.setOnClickListener(arg_0 -> UCButton.setup$lambda$0(onClick, arg_0));
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        this.setMinimumHeight(NumberExtensionsKt.dpToPx(40, context));
        if (Build.VERSION.SDK_INT >= 21) {
            this.getUcButtonText().setLetterSpacing(0.0f);
        }
        if (settings.getBackgroundColor() != null) {
            this.setCustomBackground(settings.getBackgroundColor(), settings.getCornerRadius());
        }
        UCTextView $this$setup_u24lambda_u241 = uCTextView = this.getUcButtonText();
        boolean bl = false;
        $this$setup_u24lambda_u241.setTypeface(settings.getFont());
        $this$setup_u24lambda_u241.setTextSize(2, settings.getTextSizeInSp());
        $this$setup_u24lambda_u241.setAllCaps(settings.isAllCaps());
        if (settings.getTextColor() != null) {
            $this$setup_u24lambda_u241.setTextColor(settings.getTextColor());
        }
    }

    private final void setCustomBackground(int color, int cornerRadius) {
        GradientDrawable gradientDrawable = new GradientDrawable();
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        gradientDrawable.setCornerRadius((float)NumberExtensionsKt.dpToPx(cornerRadius, context));
        gradientDrawable.setColor(color);
        this.getUcButtonBackground().setBackground((Drawable)gradientDrawable);
    }

    private static final void setup$lambda$0(Function0 $onClick, View it) {
        Intrinsics.checkNotNullParameter((Object)$onClick, (String)"$onClick");
        $onClick.invoke();
    }
}

