/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.ui.components.links;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Paint;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.usercentrics.sdk.ui.components.UCTextView;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/usercentrics/sdk/ui/components/links/LinksViewBuilder;", "", "()V", "buttonLayoutParams", "Landroid/widget/LinearLayout$LayoutParams;", "horizontalSpacing", "", "createLinksLayout", "Landroid/view/ViewGroup;", "context", "Landroid/content/Context;", "links", "", "Lcom/usercentrics/sdk/ui/components/UCTextView;", "createNewRowLayout", "Landroid/widget/LinearLayout;", "usercentrics-ui_release"})
public final class LinksViewBuilder {
    @NotNull
    public static final LinksViewBuilder INSTANCE = new LinksViewBuilder();

    private LinksViewBuilder() {
    }

    @NotNull
    public final ViewGroup createLinksLayout(@NotNull Context context, @NotNull List<? extends UCTextView> links, int horizontalSpacing) {
        LinearLayout linearLayout;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(links, (String)"links");
        Paint paint = new Paint();
        int screenWidth = Resources.getSystem().getDisplayMetrics().widthPixels;
        int horizontalPadding = horizontalSpacing * 2;
        LinearLayout $this$createLinksLayout_u24lambda_u240 = linearLayout = new LinearLayout(context);
        boolean bl = false;
        $this$createLinksLayout_u24lambda_u240.setOrientation(1);
        LinearLayout mainLayout = linearLayout;
        LinearLayout rowLayout = this.createNewRowLayout(context);
        float currentRowWidth = 0.0f;
        for (UCTextView uCTextView : links) {
            paint.setTextSize(uCTextView.getTextSize());
            float textWidth = paint.measureText(((Object)uCTextView.getText()).toString()) + (float)horizontalPadding;
            if (currentRowWidth + textWidth > (float)screenWidth) {
                mainLayout.addView((View)rowLayout);
                rowLayout = this.createNewRowLayout(context);
                currentRowWidth = 0.0f;
            }
            rowLayout.addView((View)uCTextView, (ViewGroup.LayoutParams)this.buttonLayoutParams(horizontalSpacing));
            currentRowWidth += textWidth;
        }
        if (rowLayout.getChildCount() > 0) {
            mainLayout.addView((View)rowLayout);
        }
        return (ViewGroup)mainLayout;
    }

    private final LinearLayout createNewRowLayout(Context context) {
        LinearLayout linearLayout;
        LinearLayout $this$createNewRowLayout_u24lambda_u241 = linearLayout = new LinearLayout(context);
        boolean bl = false;
        $this$createNewRowLayout_u24lambda_u241.setOrientation(0);
        $this$createNewRowLayout_u24lambda_u241.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        return linearLayout;
    }

    private final LinearLayout.LayoutParams buttonLayoutParams(int horizontalSpacing) {
        LinearLayout.LayoutParams layoutParams;
        LinearLayout.LayoutParams $this$buttonLayoutParams_u24lambda_u242 = layoutParams = new LinearLayout.LayoutParams(-2, -2);
        boolean bl = false;
        $this$buttonLayoutParams_u24lambda_u242.setMargins(0, 0, horizontalSpacing, 0);
        return layoutParams;
    }
}

