/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.ui.extensions;

import android.graphics.Color;
import androidx.annotation.ColorInt;
import com.usercentrics.sdk.ui.PredefinedUIDependencyManager;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0002*\u00020\u0001H\u0001\u00a2\u0006\u0002\u0010\u0004\u001a\f\u0010\u0005\u001a\u00020\u0002*\u00020\u0001H\u0001\u001a\u0014\u0010\u0006\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a8\u0006\t"}, d2={"colorToHexWithNoAlpha", "", "", "parseColor", "(Ljava/lang/String;)Ljava/lang/Integer;", "unsafeParseColor", "withAlpha", "alpha", "", "usercentrics-ui_release"})
public final class ColorExtensionsKt {
    @ColorInt
    @Nullable
    public static final Integer parseColor(@NotNull String $this$parseColor) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$parseColor, (String)"<this>");
        try {
            n = ColorExtensionsKt.unsafeParseColor($this$parseColor);
        }
        catch (Throwable e) {
            PredefinedUIDependencyManager.INSTANCE.getLogger().error("Error when parsing color with HEX<" + $this$parseColor + '>', e);
            if (_Assertions.ENABLED) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            n = null;
        }
        return n;
    }

    @ColorInt
    public static final int unsafeParseColor(@NotNull String $this$unsafeParseColor) {
        Intrinsics.checkNotNullParameter((Object)$this$unsafeParseColor, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$unsafeParseColor, (String)"#", (boolean)false, (int)2, null) ? Color.parseColor((String)$this$unsafeParseColor) : Color.parseColor((String)('#' + $this$unsafeParseColor));
    }

    @NotNull
    public static final String withAlpha(@NotNull String $this$withAlpha, double alpha) {
        String string;
        boolean startsWithHash;
        Intrinsics.checkNotNullParameter((Object)$this$withAlpha, (String)"<this>");
        if (StringsKt.isBlank((CharSequence)$this$withAlpha)) {
            return "";
        }
        long alphaFixed = MathKt.roundToLong((double)(alpha * (double)255));
        String alphaHex = Long.toHexString(alphaFixed);
        if (alphaHex.length() == 1) {
            alphaHex = '0' + alphaHex;
        }
        boolean bl = startsWithHash = $this$withAlpha.charAt(0) == '#';
        if (startsWithHash) {
            StringBuilder stringBuilder = new StringBuilder().append(alphaHex);
            String string2 = $this$withAlpha.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            string = stringBuilder.append(string2).toString();
        } else {
            string = alphaHex + $this$withAlpha;
        }
        String colorWithAlphaPrefix = string;
        return colorWithAlphaPrefix;
    }

    @NotNull
    public static final String colorToHexWithNoAlpha(int $this$colorToHexWithNoAlpha) {
        String string = "#%06X";
        Object[] objectArray = new Object[]{0xFFFFFF & $this$colorToHexWithNoAlpha};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }
}

