package com.usercentrics.sdk

import android.content.Context
import android.graphics.Typeface
import androidx.core.graphics.TypefaceCompat

data class BannerFont(
    val regularFont: Typeface,
    val boldFont: Typeface,
    val sizeInSp: Float
) {
    constructor(
        context: Context,
        fontFamily: Typeface,
        sizeInSp: Float
    ) : this(fontFamily.makeRegular(context), fontFamily.makeBold(context), sizeInSp)
}

private fun Typeface.makeRegular(context: Context): Typeface = TypefaceCompat.create(context, this, Typeface.NORMAL)

private fun Typeface.makeBold(context: Context): Typeface = TypefaceCompat.create(context, this, Typeface.BOLD)
