package com.usercentrics.sdk

import android.graphics.Bitmap
import android.graphics.drawable.Drawable
import androidx.annotation.DrawableRes

sealed class UsercentricsImage {
    data class ImageBitmap(val bitmap: Bitmap) : UsercentricsImage()
    data class ImageDrawableId(@DrawableRes val drawableResId: Int) : UsercentricsImage()
    data class ImageDrawable(val drawable: Drawable) : UsercentricsImage()
    data class ImageUrl(val imageUrl: String) : UsercentricsImage() {
        companion object {
            internal fun from(imageUrl: String?): UsercentricsImage? {
                return if (imageUrl?.isNotBlank() == true) {
                    ImageUrl(imageUrl)
                } else {
                    null
                }
            }
        }
    }
}
