package com.usercentrics.sdk

import com.usercentrics.sdk.ui.PredefinedUIInteraction

enum class UsercentricsUserInteraction {
    ACCEPT_ALL,
    DENY_ALL,
    GRANULAR,
    NO_INTERACTION;
}

internal fun PredefinedUIInteraction.toUsercentricsUserInteraction(): UsercentricsUserInteraction {
    return when (this) {
        PredefinedUIInteraction.ACCEPT_ALL -> UsercentricsUserInteraction.ACCEPT_ALL
        PredefinedUIInteraction.DENY_ALL -> UsercentricsUserInteraction.DENY_ALL
        PredefinedUIInteraction.GRANULAR -> UsercentricsUserInteraction.GRANULAR
        PredefinedUIInteraction.NO_INTERACTION -> UsercentricsUserInteraction.NO_INTERACTION
    }
}

internal fun UsercentricsUserInteraction.toPredefinedUIInteraction(): PredefinedUIInteraction {
    return when (this) {
        UsercentricsUserInteraction.ACCEPT_ALL -> PredefinedUIInteraction.ACCEPT_ALL
        UsercentricsUserInteraction.DENY_ALL -> PredefinedUIInteraction.DENY_ALL
        UsercentricsUserInteraction.GRANULAR -> PredefinedUIInteraction.GRANULAR
        UsercentricsUserInteraction.NO_INTERACTION -> PredefinedUIInteraction.NO_INTERACTION
    }
}
