package com.usercentrics.sdk.ui

import com.usercentrics.sdk.UsercentricsAnalyticsEventType
import com.usercentrics.sdk.analytics.UsercentricsAnalyticsManager
import com.usercentrics.sdk.log.UsercentricsLogger
import com.usercentrics.sdk.logger.UsercentricsUILoggerImpl
import com.usercentrics.sdk.models.common.UsercentricsLoggerLevel
import com.usercentrics.sdk.models.settings.PredefinedUIAriaLabels
import com.usercentrics.sdk.models.settings.PredefinedUICookieInformationLabels
import com.usercentrics.sdk.models.settings.PredefinedUIDeviceStorageContent
import com.usercentrics.sdk.ui.image.UCRemoteImageService
import com.usercentrics.sdk.ui.image.UCRemoteImageServiceImpl
import com.usercentrics.sdk.v2.cookie.service.UsercentricsCookieInformationService

object PredefinedUIDependencyManager {

    var logger: UsercentricsLogger = UsercentricsUILoggerImpl(UsercentricsLoggerLevel.NONE)

    private var _cookieInformationService: UsercentricsCookieInformationService? = null
    val cookieInformationService: UsercentricsCookieInformationService
        get() = _cookieInformationService ?: NoCookieInformationService()

    private var _analyticsManager: UsercentricsAnalyticsManager? = null
    val analyticsManager: UsercentricsAnalyticsManager
        get() = _analyticsManager ?: NoAnalyticsManager()

    private var _ariaLabels: PredefinedUIAriaLabels? = null
    val ariaLabels: PredefinedUIAriaLabels
        get() = _ariaLabels ?: PredefinedUIAriaLabels()

    var remoteImageService: Lazy<UCRemoteImageService> = lazy {
        UCRemoteImageServiceImpl()
    }

    fun boot(
        logger: UsercentricsLogger,
        cookieInformationService: UsercentricsCookieInformationService,
        analyticsManager: UsercentricsAnalyticsManager,
        ariaLabels: PredefinedUIAriaLabels,
    ) {
        this.logger = logger
        _cookieInformationService = cookieInformationService
        _analyticsManager = analyticsManager
        _ariaLabels = ariaLabels
    }

    fun tearDown() {
        _cookieInformationService = null
        remoteImageService = lazy { UCRemoteImageServiceImpl() }
        _analyticsManager = null
    }
}

private class NoCookieInformationService : UsercentricsCookieInformationService {

    init {
        assert(false) { "Missing cookie information dependency" }
    }

    override fun fetchCookieInfo(cookieInfoURL: String, onSuccess: (List<PredefinedUIDeviceStorageContent>) -> Unit, onError: () -> Unit) {
        onError()
    }

    override fun cookieInformationLabels(): PredefinedUICookieInformationLabels? {
        return null
    }

}

private class NoAnalyticsManager : UsercentricsAnalyticsManager {

    init {
        assert(false) { "Missing analytics dependency" }
    }

    override fun track(event: UsercentricsAnalyticsEventType) {
    }
}
