package com.usercentrics.sdk.ui.components

import android.content.Context
import android.util.AttributeSet
import androidx.annotation.AttrRes
import com.usercentrics.sdk.ui.R
import com.usercentrics.sdk.ui.components.cards.UCSectionTitlePM
import com.usercentrics.sdk.ui.theme.UCThemeData

internal class UCSectionTitle : UCTextView {

    constructor(context: Context) : this(context, null)
    constructor(context: Context, attrs: AttributeSet?) : this(context, attrs, 0)
    constructor(context: Context, attrs: AttributeSet?, @AttrRes defStyleAttr: Int) : super(context, attrs, defStyleAttr) {
        val horizontalPadding = context.resources.getDimension(R.dimen.ucCardHorizontalMargin).toInt()
        val verticalPadding = context.resources.getDimension(R.dimen.ucCardVerticalMargin).toInt()
        setPaddingRelative(horizontalPadding, verticalPadding, 0, 0)
    }

    fun style(theme: UCThemeData) {
        styleSectionTitle(theme)
    }

    fun bind(model: UCSectionTitlePM) {
        text = model.title
    }
}
