package com.usercentrics.sdk.ui.components

import android.content.Context
import android.content.res.ColorStateList
import android.util.AttributeSet
import android.widget.CompoundButton
import androidx.annotation.AttrRes
import androidx.appcompat.R
import androidx.appcompat.widget.SwitchCompat
import com.usercentrics.sdk.models.settings.PredefinedUISwitchSettingsUI
import com.usercentrics.sdk.models.settings.PredefinedUIToggleSettings
import com.usercentrics.sdk.ui.theme.UCThemeData
import com.usercentrics.sdk.ui.theme.UCToggleTheme
import com.usercentrics.sdk.ui.toggle.PredefinedUIAbstractToggle
import com.usercentrics.sdk.ui.toggle.PredefinedUIToggleGroup
import com.usercentrics.sdk.ui.toggle.PredefinedUIToggleMediator

class UCToggle : SwitchCompat, PredefinedUIAbstractToggle, CompoundButton.OnCheckedChangeListener {
    constructor(context: Context) : this(context, null)
    constructor(context: Context, attrs: AttributeSet?) : this(context, attrs, R.attr.switchStyle)
    constructor(
        context: Context,
        attrs: AttributeSet?,
        @AttrRes defStyleAttr: Int
    ) : super(context, attrs, defStyleAttr)

    private var listener: ((Boolean) -> Unit) = {}

    private var group: PredefinedUIToggleGroup? = null

    override var currentState: Boolean
        get() = isChecked
        set(value) {
            setOnCheckedChangeListener(null)
            isChecked = value
            setOnCheckedChangeListener(this)
            minimumHeight = resources.getDimensionPixelOffset(com.usercentrics.sdk.ui.R.dimen.ucFirstLayerLegalLinksOrButtonsMinimumHeight)
        }

    init {
        setOnCheckedChangeListener(this)
    }

    override fun setListener(listener: ((Boolean) -> Unit)?) {
        this.listener = listener ?: {}
    }

    override fun dispose() {
        group = null
        listener = {}
        setOnCheckedChangeListener(null)
    }

    override fun onCheckedChanged(buttonView: CompoundButton?, isChecked: Boolean) {
        listener(isChecked)
    }

    internal fun bindLegacy(model: UCTogglePM) {
        group?.unbind(this)
        isChecked = model.initialStatus
        isEnabled = model.isEnabled
        group = model.group?.apply {
            bind(this@UCToggle)
        }
    }

    fun bind(toggleMediator: PredefinedUIToggleMediator, settings: PredefinedUIToggleSettings) {
        group?.unbind(this)
        isChecked = settings.currentValue
        isEnabled = settings.isEnabled
        group = toggleMediator.getGroup(settings).apply {
            bind(this@UCToggle)
        }
    }

    override fun onAttachedToWindow() {
        super.onAttachedToWindow()
        group?.bind(this)
    }

    override fun onDetachedFromWindow() {
        group?.unbind(this)
        super.onDetachedFromWindow()
    }

    fun styleToggle(theme: UCThemeData) {
        val toggleTheme = theme.toggleTheme ?: return

        val states = arrayOf(
            UCToggleTheme.stateDisabledAndNotChecked,
            UCToggleTheme.stateDisabledAndChecked,
            UCToggleTheme.stateEnabledAndChecked,
            UCToggleTheme.stateEnabledAndNotChecked
        )

        val trackColors = intArrayOf(
            toggleTheme.disabledBackground,
            toggleTheme.disabledBackground,
            toggleTheme.activeBackground,
            toggleTheme.inactiveBackground
        )

        val thumbColors = intArrayOf(
            toggleTheme.disabledIcon,
            toggleTheme.disabledIcon,
            toggleTheme.activeIcon,
            toggleTheme.inactiveIcon
        )

        trackTintList = ColorStateList(states, trackColors)
        thumbTintList = ColorStateList(states, thumbColors)
        background = null
    }
}

internal class UCTogglePM(
    val initialStatus: Boolean,
    val isEnabled: Boolean,
    val group: PredefinedUIToggleGroup?,
    val label: String? = null
) {

    constructor(
        switchSettings: PredefinedUISwitchSettingsUI,
        group: PredefinedUIToggleGroup?
    ) : this(
        initialStatus = switchSettings.currentValue,
        isEnabled = !switchSettings.disabled,
        group = group,
        label = switchSettings.label
    )
}
