package com.usercentrics.sdk.ui.components.cards

import android.content.Context
import android.graphics.drawable.GradientDrawable
import android.view.View
import android.view.ViewGroup
import com.google.android.flexbox.FlexboxLayout
import com.usercentrics.sdk.ui.R
import com.usercentrics.sdk.ui.accessibility.createAccessibilityLinkOrButton
import com.usercentrics.sdk.ui.components.UCTextView
import com.usercentrics.sdk.ui.components.links.UCLink
import com.usercentrics.sdk.ui.extensions.dpToPx
import com.usercentrics.sdk.ui.extensions.inflater
import com.usercentrics.sdk.ui.theme.UCThemeData

internal fun buildTextSectionView(
    context: Context,
    parent: ViewGroup,
    theme: UCThemeData,
    textSectionPM: UCContentTextSectionPM
): View {
    val colorPalette = theme.colorPalette

    val textSection = context.inflater.inflate(R.layout.uc_card_section_entry, parent, false)

    // Title
    val titleView = textSection.findViewById<UCTextView>(R.id.ucCardSectionEntryTitle)
    val title = textSectionPM.title
    if (title.isNullOrBlank()) {
        titleView.visibility = View.GONE
    } else {
        titleView.text = title
        titleView.styleBody(theme, isSecondary = true)
    }

    // Description
    val description = textSection.findViewById<UCTextView>(R.id.ucCardSectionEntryDescription)
    if (textSectionPM.description.isNullOrBlank()) {
        description.visibility = View.GONE
    } else {
        description.visibility = View.VISIBLE
        description.text = textSectionPM.description
        description.styleBody(theme)
    }

    val content = textSection.findViewById<FlexboxLayout>(R.id.ucCardSectionEntryFlexbox)

    // Link
    textSectionPM.link?.let {
        val link = UCLink(context)
        link.styleMedium(theme)
        link.bindLegacy(it)
        content.addView(link)
        link.createAccessibilityLinkOrButton()
    }

    // Tags
    for (infoTag in textSectionPM.tags) {
        val tag = context.inflater.inflate(R.layout.uc_tag, content, false) as UCTextView
        tag.text = infoTag
        tag.background = GradientDrawable().apply {
            shape = GradientDrawable.RECTANGLE
            cornerRadius = 2.dpToPx(context).toFloat()
            setStroke(1.dpToPx(context), colorPalette.tabsBorderColor)
            colorPalette.layerBackgroundColor?.let { setColor(it) }
        }
        tag.styleBody(theme)
        content.addView(tag)
    }

    return textSection
}
