package com.usercentrics.sdk.ui.components.cookie

import com.usercentrics.sdk.models.settings.PredefinedUIDeviceStorageContent
import com.usercentrics.sdk.models.settings.PredefinedUIStorageInformationButtonInfo
import com.usercentrics.sdk.ui.PredefinedUIDependencyManager
import com.usercentrics.sdk.v2.cookie.service.UsercentricsCookieInformationService

internal interface UCCookiesViewModel {
    val titleDetailed: String
    val loading: String
    val error: String
    val tryAgain: String

    fun onDismiss()
    fun loadInformation(
        onSuccess: (disclosures: List<PredefinedUIDeviceStorageContent>) -> Unit,
        onError: () -> Unit
    )
}

internal class UCCookiesViewModelImpl(
    private val storageInformation: PredefinedUIStorageInformationButtonInfo,
    private val dismissCallback: () ->Unit
) : UCCookiesViewModel {

    private val cookieInformationService: UsercentricsCookieInformationService by lazy { PredefinedUIDependencyManager.cookieInformationService }
    private val cookieLabels by lazy { cookieInformationService.cookieInformationLabels() }

    override val titleDetailed: String
        get() = cookieLabels?.titleDetailed ?: ""
    override val loading: String
        get() = cookieLabels?.loading ?: ""
    override val error: String
        get() = cookieLabels?.error ?: ""
    override val tryAgain: String
        get() = cookieLabels?.tryAgain ?: ""

    override fun onDismiss() {
        dismissCallback()
    }

    override fun loadInformation(
        onSuccess: (disclosures: List<PredefinedUIDeviceStorageContent>) -> Unit,
        onError: () -> Unit
    ) {
        val disclosures = storageInformation.deviceStorage

        val url = storageInformation.url
        if (!url.isNullOrEmpty()) {
            loadFromUrl(url, onSuccess, onError)
        } else if (!disclosures.isNullOrEmpty()) {
            onSuccess(disclosures)
        }
    }

    private fun loadFromUrl(
        url: String,
        onSuccess: (disclosures: List<PredefinedUIDeviceStorageContent>) -> Unit,
        onError: () -> Unit
    ) {
        cookieInformationService.fetchCookieInfo(url,
            onSuccess = {
                onSuccess(it)
            }, onError = {
                onError()
            })
    }

}
