package com.usercentrics.sdk.ui.components.links

import android.content.Context
import android.content.res.Resources
import android.graphics.Paint
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.usercentrics.sdk.ui.components.UCTextView

object LinksViewBuilder {

    fun createLinksLayout(context: Context, links: List<View>, horizontalSpacing: Int): ViewGroup {
        val paint = Paint()
        val screenWidth = Resources.getSystem().displayMetrics.widthPixels
        val horizontalPadding = horizontalSpacing * 2

        val mainLayout = LinearLayout(context).apply {
            orientation = LinearLayout.VERTICAL
        }

        var rowLayout = createNewRowLayout(context)
        var currentRowWidth = 0f

        for (button in links) {
            val textWidth = if (button is UCTextView) {
                paint.textSize = button.textSize
                paint.measureText(button.text.toString()) + horizontalPadding
            } else {
                button.measuredWidth.toFloat() + horizontalPadding
            }

            if (currentRowWidth + textWidth > screenWidth) {
                mainLayout.addView(rowLayout)

                rowLayout = createNewRowLayout(context)
                currentRowWidth = 0f
            }

            rowLayout.addView(button, buttonLayoutParams(horizontalSpacing))
            currentRowWidth += textWidth
        }

        if (rowLayout.childCount > 0) {
            mainLayout.addView(rowLayout)
        }
        return mainLayout
    }

    private fun createNewRowLayout(context: Context): LinearLayout {
        return LinearLayout(context).apply {
            orientation = LinearLayout.HORIZONTAL
            layoutParams = LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT)
        }
    }

    private fun buttonLayoutParams(horizontalSpacing: Int): LinearLayout.LayoutParams {
        return LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT).apply {
            marginStart = 0
            marginEnd = horizontalSpacing
        }
    }
}
