package com.usercentrics.sdk.ui.components.links

import android.content.Context
import android.util.AttributeSet
import android.view.Gravity
import android.view.LayoutInflater
import androidx.annotation.AttrRes
import androidx.appcompat.widget.LinearLayoutCompat
import com.usercentrics.sdk.ui.R
import com.usercentrics.sdk.ui.components.UCTextView
import com.usercentrics.sdk.ui.extensions.setVerticalPadding
import com.usercentrics.sdk.ui.theme.UCThemeData

internal class UCLink : LinearLayoutCompat {

    private val ucLinkText: UCTextView by lazy { findViewById(R.id.ucLinkText) }

    constructor(context: Context) : this(context, null)
    constructor(context: Context, attrs: AttributeSet?) : this(context, attrs, 0)
    constructor(context: Context, attrs: AttributeSet?, @AttrRes defStyleAttr: Int) : super(context, attrs, defStyleAttr) {
        initLayout(context)
    }

    fun styleMedium(theme: UCThemeData) {
        ucLinkText.styleBody(theme, isLink = true)
    }

    fun bindLegacy(model: UCLinkPMLegacy) {
        setLinkText(model.label)
        setOnClickListener { model.callback() }
    }

    private fun initLayout(context: Context) {
        LayoutInflater.from(context).inflate(R.layout.uc_link, this)
        orientation = HORIZONTAL
        gravity = Gravity.CENTER
        setVerticalPadding(resources.getDimension(R.dimen.ucLinkVerticalPadding).toInt())
    }

    private fun setLinkText(text: String) {
        ucLinkText.text = text
    }
}

internal class UCLinkPMLegacy(
    val label: String,
    val callback: () -> Unit,
)
