package com.usercentrics.sdk.ui.extensions

import java.util.*
import kotlin.collections.ArrayList

internal fun <T> MutableList<T>.addIfAbsent(item: T): Boolean {
    return if (!contains(item)) {
        add(item)
    } else {
        false
    }
}

internal fun <T : CharSequence> Iterable<T>.filterNotBlank(): List<T> {
    val destination = ArrayList<T>()
    for (element in this) if (element.isNotBlank()) destination.add(element)
    return destination
}

internal fun <E> MutableSet<E>.set(item: E, isAdd: Boolean): Boolean {
    return if (isAdd) {
        add(item)
    } else {
        remove(item)
    }
}

internal fun <E> LinkedList<E>.popOrNull(): E? {
    return try {
        pop()
    } catch (e: NoSuchElementException) {
        null
    }
}

internal fun <T : Collection<*>> T?.emptyToNull(): T? {
    return if (this?.isEmpty() == true) {
        null
    } else {
        this
    }
}
