package com.usercentrics.sdk.ui.extensions

import android.graphics.Color
import androidx.annotation.ColorInt
import com.usercentrics.sdk.ui.PredefinedUIDependencyManager
import kotlin.math.roundToLong

@ColorInt
internal fun String.parseColor(): Int? {
    return try {
        unsafeParseColor()
    } catch (e: Throwable) {
        PredefinedUIDependencyManager.logger.error("Error when parsing color with HEX<$this>", e)
        assert(false)
        null
    }
}

@ColorInt
internal fun String.unsafeParseColor(): Int {
    return if (this.startsWith("#")) {
        Color.parseColor(this)
    } else {
        Color.parseColor("#$this")
    }
}

internal fun String.withAlpha(alpha: Double): String {
    if (this.isBlank()) {
        return ""
    }

    val alphaFixed = (alpha * 255).roundToLong()
    var alphaHex = java.lang.Long.toHexString(alphaFixed)
    if (alphaHex.length == 1) {
        alphaHex = "0$alphaHex"
    }

    val startsWithHash = this[0] == '#'
    val colorWithAlphaPrefix = if (startsWithHash) {
        "$alphaHex${this.substring(1)}"
    } else {
        "$alphaHex$this"
    }
    return colorWithAlphaPrefix
}

internal fun Int.colorToHexWithNoAlpha(): String {
    return String.format("#%06X", (0xFFFFFF and this))
}
