package com.usercentrics.sdk.ui.extensions

import android.view.View
import android.view.ViewGroup
import androidx.annotation.LayoutRes
import androidx.recyclerview.widget.RecyclerView

internal fun ViewGroup.inflate(@LayoutRes resId: Int, attachToRoot: Boolean = false): View =
    context.inflater.inflate(resId, this, attachToRoot)

internal fun View.setPaddingBottom(pixels: Int) {
    setPaddingRelative(paddingLeft, paddingTop, paddingRight, pixels)
}

internal fun View.setPaddingRight(pixels: Int) {
    setPaddingRelative(paddingLeft, paddingTop, pixels, paddingBottom)
}

internal fun View.setVerticalPadding(pixels: Int) {
    setPaddingRelative(paddingLeft, pixels, paddingRight, pixels)
}

internal fun View.setHorizontalPadding(pixels: Int) {
    setPaddingRelative(pixels, paddingTop, pixels, paddingBottom)
}

internal fun View.setRVMargins(
    horizontalMarginPx: Int,
    verticalMarginPx: Int,
    hasBottom: Boolean = true
) {
    this.layoutParams = RecyclerView.LayoutParams(
        RecyclerView.LayoutParams.MATCH_PARENT,
        RecyclerView.LayoutParams.WRAP_CONTENT
    ).apply {
        marginStart = horizontalMarginPx
        topMargin = verticalMarginPx
        marginEnd = horizontalMarginPx
        bottomMargin = if (hasBottom) verticalMarginPx else 0
    }
}

internal fun View.setMarginBottom(margin: Int) {
    (this.layoutParams as ViewGroup.MarginLayoutParams).apply {
        bottomMargin = margin
    }
}

internal fun View.setMarginTop(margin: Int) {
    (this.layoutParams as ViewGroup.MarginLayoutParams).apply {
        topMargin = margin
    }
}
