package com.usercentrics.sdk.ui.firstLayer.component

import android.content.Context
import androidx.appcompat.widget.LinearLayoutCompat
import androidx.core.view.marginTop
import com.usercentrics.sdk.ui.R
import com.usercentrics.sdk.ui.components.UCButton
import com.usercentrics.sdk.ui.components.UCButtonSettings
import com.usercentrics.sdk.ui.extensions.dpToPx
import com.usercentrics.sdk.ui.firstLayer.UCFirstLayerViewModel

internal fun LinearLayoutCompat.addButtons(viewModel: UCFirstLayerViewModel) {
    val innerPadding = resources.getDimensionPixelOffset(R.dimen.ucFirstLayerInnerPadding)
    val buttonsSpacing = resources.getDimensionPixelOffset(R.dimen.ucFirstLayerButtonsSpacing)
    viewModel.buttons.forEachIndexed { index, row ->
        addRowButton(
            viewModel = viewModel,
            innerPadding = innerPadding,
            buttonsSpacing = buttonsSpacing,
            buttonList = row,
            isTheFirstOne = index == 0,
            isTheLastOne = index == viewModel.buttons.lastIndex
        )
    }
}

private fun LinearLayoutCompat.addRowButton(
    viewModel: UCFirstLayerViewModel,
    innerPadding: Int,
    buttonsSpacing: Int,
    buttonList: List<UCButtonSettings>,
    isTheFirstOne: Boolean,
    isTheLastOne: Boolean,
) {
    val horizontalRow = LinearLayoutCompat(context).apply {
        orientation = LinearLayoutCompat.HORIZONTAL
    }

    buttonList.forEachIndexed { index, button ->
        val buttonView = createButtonView(context, viewModel, button)
        val buttonLayoutParams = LinearLayoutCompat.LayoutParams(
            0, LinearLayoutCompat.LayoutParams.MATCH_PARENT, 1F
        ).apply {
            val buttonMargin = if (index == 0) 0 else buttonsSpacing
            marginStart = buttonMargin
            marginEnd = 0
        }
        horizontalRow.addView(buttonView, buttonLayoutParams)
    }

    val layoutParams = LinearLayoutCompat.LayoutParams(LinearLayoutCompat.LayoutParams.MATCH_PARENT, LinearLayoutCompat.LayoutParams.WRAP_CONTENT).apply {
        val hasToggleBefore = viewModel.ccpaToggle != null
        val marginTop = when {
            isTheFirstOne && hasToggleBefore -> 0
            isTheFirstOne -> innerPadding
            else -> buttonsSpacing
        }
        val hasPoweredByAfter = viewModel.poweredByLabel != null
        val marginBottom = when {
            isTheLastOne && hasPoweredByAfter -> resources.getDimensionPixelOffset(R.dimen.ucFirstLayerPoweredByVerticalMargin)
            isTheLastOne -> resources.getDimensionPixelOffset(R.dimen.ucFirstLayerInnerPadding)
            else -> 0
        }

        marginStart = innerPadding
        marginEnd = innerPadding
        topMargin = marginTop
        bottomMargin = marginBottom
    }
    addView(horizontalRow, layoutParams)
}

private fun LinearLayoutCompat.createButtonView(
    context: Context,
    viewModel: UCFirstLayerViewModel,
    button: UCButtonSettings,
): UCButton {
    val buttonView = UCButton(context).apply {
        setup(button) {
            viewModel.onButtonClick(button.type)
        }
        // TODO check why the first layer buttons has 50 minHeight and the second layer 40
        minimumHeight = 50.dpToPx(context)
    }
    return buttonView
}
