package com.usercentrics.sdk.ui.firstLayer.component

import android.view.Gravity
import androidx.appcompat.widget.LinearLayoutCompat
import com.usercentrics.sdk.ui.R
import com.usercentrics.sdk.ui.accessibility.accessibleTouchTarget
import com.usercentrics.sdk.ui.components.UCTextView
import com.usercentrics.sdk.ui.components.UCToggle
import com.usercentrics.sdk.ui.firstLayer.UCFirstLayerViewModel
import com.usercentrics.sdk.ui.theme.UCThemeData

internal fun LinearLayoutCompat.addCCPAToggle(theme: UCThemeData, viewModel: UCFirstLayerViewModel) {
    val ccpaToggle = viewModel.ccpaToggle ?: return

    val container = LinearLayoutCompat(context).apply {
        orientation = LinearLayoutCompat.HORIZONTAL
        gravity = Gravity.CENTER
    }
    val toggleView = UCToggle(context).apply {
        styleToggle(theme)
        currentState = ccpaToggle.initialValue
        setListener {
            viewModel.onCCPAToggleChanged(it)
        }
    }
    val labelView = UCTextView(context).apply {
        styleBody(theme)
        text = ccpaToggle.label
        setOnClickListener { toggleView.toggle() }
    }

    container.addView(toggleView)
    container.addView(
        labelView,
        LinearLayoutCompat.LayoutParams(LinearLayoutCompat.LayoutParams.MATCH_PARENT, LinearLayoutCompat.LayoutParams.WRAP_CONTENT, 100f).apply {
            val toggleTextSpacing = resources.getDimensionPixelOffset(R.dimen.ucFirstLayerToggleTextSpacing)

            marginStart = toggleTextSpacing
            marginEnd = 0
        }
    )

    toggleView.accessibleTouchTarget()
    labelView.accessibleTouchTarget()

    addView(
        container,
        LinearLayoutCompat.LayoutParams(LinearLayoutCompat.LayoutParams.MATCH_PARENT, LinearLayoutCompat.LayoutParams.WRAP_CONTENT).apply {
            val horizontalMargin = resources.getDimensionPixelOffset(R.dimen.ucFirstLayerInnerPadding)
            val verticalMargin = resources.getDimensionPixelOffset(R.dimen.ucFirstLayerToggleVerticalMargin)

            marginStart = horizontalMargin
            marginEnd = horizontalMargin
            topMargin = verticalMargin
            bottomMargin = verticalMargin
        }
    )
}
