package com.usercentrics.sdk.ui.image

import java.net.HttpURLConnection
import java.net.URL

internal class UCRemoteImageServiceImpl : UCRemoteImageService {

    companion object {
        private const val defaultTimeoutMillis = 10_000
    }

    override fun getImage(imageUrl: String): UCRemoteImage {
        return (URL(imageUrl).openConnection() as HttpURLConnection).apply {
            requestMethod = "GET"
            readTimeout = defaultTimeoutMillis
        }.use()
    }

    private fun HttpURLConnection.use(): UCRemoteImage {
        try {
            connect()
            return UCRemoteImage(
                headers = headerFields,
                payload = inputStream.readBytes()
            )
        } finally {
            runCatching { inputStream.close() }
            runCatching { disconnect() }
        }
    }
}
