package com.usercentrics.sdk.ui.theme

import androidx.annotation.ColorInt
import com.usercentrics.sdk.models.settings.PredefinedUICustomizationColor
import com.usercentrics.sdk.models.settings.PredefinedUICustomizationColorButton
import com.usercentrics.sdk.ui.extensions.parseColor

data class UCButtonTheme(
    val acceptAll: UCButtonCustomization,
    val denyAll: UCButtonCustomization,
    val manage: UCButtonCustomization,
    val save: UCButtonCustomization,
    val ok: UCButtonCustomization,
) {
    companion object {
        fun createFrom(customization: PredefinedUICustomizationColor): UCButtonTheme {
            return UCButtonTheme(
                acceptAll = UCButtonCustomization.createFrom(customization.acceptAllButton),
                denyAll = UCButtonCustomization.createFrom(customization.denyAllButton),
                manage = UCButtonCustomization.createFrom(customization.manageButton),
                save = UCButtonCustomization.createFrom(customization.saveButton),
                ok = UCButtonCustomization.createFrom(customization.okButton),
            )
        }
    }
}

data class UCButtonCustomization(
    @ColorInt val text: Int?,
    @ColorInt val background: Int?,
    val cornerRadius: Int
) {
    companion object {
        fun createFrom(customization: PredefinedUICustomizationColorButton): UCButtonCustomization {
            return UCButtonCustomization(
                text = customization.text.parseColor(),
                background = customization.background.parseColor(),
                cornerRadius = customization.cornerRadius
            )
        }
    }
}
