package com.usercentrics.sdk.ui.theme

import android.graphics.Typeface
import com.usercentrics.sdk.BannerFont
import com.usercentrics.sdk.models.settings.PredefinedUICustomizationFont

data class UCFontTheme(
    val font: Typeface,
    val fontBold: Typeface,
    val sizes: UCFontSize
) {

    companion object {
        internal fun create(
            font: PredefinedUICustomizationFont,
            customFont: BannerFont?
        ): UCFontTheme {
            // Use the custom font if present
            return if (customFont != null) {
                UCFontTheme(customFont.regularFont, customFont.boldFont, UCFontSize.create(customFont.sizeInSp))
            } else {
                UCFontTheme(Typeface.DEFAULT, Typeface.DEFAULT_BOLD, UCFontSize.create(font.size.toFloat()))
            }
        }

    }
}

data class UCFontSize(
    val title: Float,
    val body: Float,
    val small: Float,
    val tiny: Float
) {
    companion object {
        fun create(baseSizeInSp: Float): UCFontSize {
            return UCFontSize(
                title = baseSizeInSp + 2,
                body = baseSizeInSp,
                small = baseSizeInSp - 2,
                tiny = baseSizeInSp - 4
            )
        }
    }
}
