package com.usercentrics.sdk.ui.theme

import com.usercentrics.sdk.GeneralStyleSettings
import com.usercentrics.sdk.models.settings.PredefinedUICustomization

data class UCThemeData(
    val colorPalette: UCColorPalette,
    val fonts: UCFontTheme,
    val toggleTheme: UCToggleTheme?,
    val buttonTheme: UCButtonTheme,
    val bannerCornerRadius: Int,
) {
    companion object {
        fun createFrom(customization: PredefinedUICustomization, generalStyleSettings: GeneralStyleSettings?): UCThemeData {
            return UCThemeData(
                colorPalette = UCColorPalette.createFrom(customization.color, generalStyleSettings),
                fonts = UCFontTheme.create(
                    customization.font,
                    generalStyleSettings?.font
                ),
                toggleTheme = UCToggleTheme.create(
                    customization.color.toggles,
                    generalStyleSettings?.toggleStyleSettings
                ),
                bannerCornerRadius = customization.cornerRadius,
                buttonTheme = UCButtonTheme.createFrom(customization.color)
            )
        }
    }
}
