package com.usercentrics.sdk.unity

import com.usercentrics.sdk.unity.model.*
import kotlinx.serialization.KSerializer
import kotlinx.serialization.decodeFromString
import kotlinx.serialization.descriptors.PrimitiveKind
import kotlinx.serialization.descriptors.PrimitiveSerialDescriptor
import kotlinx.serialization.descriptors.SerialDescriptor
import kotlinx.serialization.encoding.Decoder
import kotlinx.serialization.encoding.Encoder
import kotlinx.serialization.json.Json
import kotlinx.serialization.modules.SerializersModule

internal class UnityUIJsonParser {

    private val json = Json {
        ignoreUnknownKeys = true
        coerceInputValues = true

        serializersModule = SerializersModule {
            contextual(UnityUsercentricsLayout::class, unitySerializerEnum())
            contextual(UnitySectionAlignment::class, unitySerializerEnum())
            contextual(UnityHeaderImageType::class, unitySerializerEnum())
            contextual(UnityButtonLayoutType::class, unitySerializerEnum())
            contextual(UnityButtonType::class, unitySerializerEnum())
            contextual(UnityLegalLinksSettings::class, unitySerializerEnum())
        }
    }

    inline fun <reified T> decodeFromString(str: String): T {
        return json.decodeFromString(str)
    }

    private inline fun <reified T : Enum<T>> unitySerializerEnum(): KSerializer<T> {
        return object : KSerializer<T> {

            override val descriptor: SerialDescriptor = PrimitiveSerialDescriptor("${T::class.simpleName}", PrimitiveKind.INT)

            override fun deserialize(decoder: Decoder): T {
                return enumValues<T>()[decoder.decodeInt()]
            }

            override fun serialize(encoder: Encoder, value: T) {
                encoder.encodeInt(value.ordinal)
            }
        }
    }
}
