/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.ui.accessibility;

import android.content.Context;
import android.graphics.Rect;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewParent;
import com.usercentrics.sdk.ui.R;
import com.usercentrics.sdk.ui.extensions.ContextExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0002H\u0000\u00a8\u0006\u0004"}, d2={"accessibleTouchTarget", "", "Landroid/view/View;", "createAccessibilityLinkOrButton", "usercentrics-ui_release"})
public final class AccessibilityUIKt {
    public static final void createAccessibilityLinkOrButton(@NotNull View $this$createAccessibilityLinkOrButton) {
        Intrinsics.checkNotNullParameter((Object)$this$createAccessibilityLinkOrButton, (String)"<this>");
        $this$createAccessibilityLinkOrButton.setMinimumWidth($this$createAccessibilityLinkOrButton.getResources().getDimensionPixelOffset(R.dimen.ucFirstLayerLegalLinksOrButtonsMinimumWidth));
        $this$createAccessibilityLinkOrButton.setMinimumHeight($this$createAccessibilityLinkOrButton.getResources().getDimensionPixelOffset(R.dimen.ucFirstLayerLegalLinksOrButtonsMinimumHeight));
        $this$createAccessibilityLinkOrButton.setFocusable(true);
    }

    public static final void accessibleTouchTarget(@NotNull View $this$accessibleTouchTarget) {
        Intrinsics.checkNotNullParameter((Object)$this$accessibleTouchTarget, (String)"<this>");
        $this$accessibleTouchTarget.post(() -> AccessibilityUIKt.accessibleTouchTarget$lambda$0($this$accessibleTouchTarget));
    }

    private static final void accessibleTouchTarget$lambda$0(View $this_accessibleTouchTarget) {
        ViewParent viewParent;
        View parentView;
        int width;
        Intrinsics.checkNotNullParameter((Object)$this_accessibleTouchTarget, (String)"$this_accessibleTouchTarget");
        Rect delegateArea = new Rect();
        $this_accessibleTouchTarget.getHitRect(delegateArea);
        Context context = $this_accessibleTouchTarget.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        float accessibilityMin = ContextExtensionsKt.dpToPx(context, 48);
        int height = delegateArea.bottom - delegateArea.top;
        if (accessibilityMin > (float)height) {
            int addition = (int)((accessibilityMin - (float)height) / (float)2) + 1;
            delegateArea.top -= addition;
            delegateArea.bottom += addition;
        }
        if (accessibilityMin > (float)(width = delegateArea.right - delegateArea.left)) {
            int addition = (int)((accessibilityMin - (float)width) / (float)2) + 1;
            delegateArea.left -= addition;
            delegateArea.right += addition;
        }
        View view = parentView = (viewParent = $this_accessibleTouchTarget.getParent()) instanceof View ? (View)viewParent : null;
        if (parentView != null) {
            parentView.setTouchDelegate(new TouchDelegate(delegateArea, $this_accessibleTouchTarget));
        }
    }
}

