/*
 * Decompiled with CFR 0.152.
 */
package com.usercentrics.sdk.ui.components.cookie;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import com.usercentrics.sdk.models.settings.PredefinedUIDeviceStorageContent;
import com.usercentrics.sdk.ui.R;
import com.usercentrics.sdk.ui.components.UCTextView;
import com.usercentrics.sdk.ui.extensions.NumberExtensionsKt;
import com.usercentrics.sdk.ui.extensions.ViewExtensionsKt;
import com.usercentrics.sdk.ui.theme.UCThemeData;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/usercentrics/sdk/ui/components/cookie/CookieInformationAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/usercentrics/sdk/ui/components/cookie/CookieInformationAdapter$CookieViewHolder;", "theme", "Lcom/usercentrics/sdk/ui/theme/UCThemeData;", "data", "", "Lcom/usercentrics/sdk/models/settings/PredefinedUIDeviceStorageContent;", "(Lcom/usercentrics/sdk/ui/theme/UCThemeData;Ljava/util/List;)V", "getItemCount", "", "onBindViewHolder", "", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "CookieViewHolder", "usercentrics-ui_release"})
public final class CookieInformationAdapter
extends RecyclerView.Adapter<CookieViewHolder> {
    @NotNull
    private final UCThemeData theme;
    @NotNull
    private final List<PredefinedUIDeviceStorageContent> data;

    public CookieInformationAdapter(@NotNull UCThemeData theme, @NotNull List<PredefinedUIDeviceStorageContent> data) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.theme = theme;
        this.data = data;
    }

    @NotNull
    public CookieViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return new CookieViewHolder(this.theme, ViewExtensionsKt.inflate$default(parent, R.layout.uc_cookie_card, false, 2, null));
    }

    public int getItemCount() {
        return this.data.size();
    }

    public void onBindViewHolder(@NotNull CookieViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        PredefinedUIDeviceStorageContent itemData = this.data.get(position);
        holder.bindHolder(itemData);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\f\u001a\u0004\b\u000e\u0010\nR\u001b\u0010\u0010\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\f\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lcom/usercentrics/sdk/ui/components/cookie/CookieInformationAdapter$CookieViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "theme", "Lcom/usercentrics/sdk/ui/theme/UCThemeData;", "itemView", "Landroid/view/View;", "(Lcom/usercentrics/sdk/ui/theme/UCThemeData;Landroid/view/View;)V", "ucCardContent", "Lcom/usercentrics/sdk/ui/components/UCTextView;", "getUcCardContent", "()Lcom/usercentrics/sdk/ui/components/UCTextView;", "ucCardContent$delegate", "Lkotlin/Lazy;", "ucCookieCardTitle", "getUcCookieCardTitle", "ucCookieCardTitle$delegate", "ucCookieCardTitleDivider", "getUcCookieCardTitleDivider", "()Landroid/view/View;", "ucCookieCardTitleDivider$delegate", "bindHolder", "", "itemData", "Lcom/usercentrics/sdk/models/settings/PredefinedUIDeviceStorageContent;", "usercentrics-ui_release"})
    @SourceDebugExtension(value={"SMAP\nCookieInformationAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CookieInformationAdapter.kt\ncom/usercentrics/sdk/ui/components/cookie/CookieInformationAdapter$CookieViewHolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1#2:56\n*E\n"})
    public static final class CookieViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final Lazy ucCookieCardTitle$delegate;
        @NotNull
        private final Lazy ucCookieCardTitleDivider$delegate;
        @NotNull
        private final Lazy ucCardContent$delegate;

        /*
         * WARNING - void declaration
         */
        public CookieViewHolder(@NotNull UCThemeData theme, @NotNull View itemView) {
            void $this$_init__u24lambda_u241;
            GradientDrawable gradientDrawable;
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
            this.ucCookieCardTitle$delegate = LazyKt.lazy((Function0)((Function0)new Function0<UCTextView>(itemView){
                final /* synthetic */ View $itemView;
                {
                    this.$itemView = $itemView;
                    super(0);
                }

                public final UCTextView invoke() {
                    return (UCTextView)this.$itemView.findViewById(R.id.ucCookieCardTitle);
                }
            }));
            this.ucCookieCardTitleDivider$delegate = LazyKt.lazy((Function0)((Function0)new Function0<View>(itemView){
                final /* synthetic */ View $itemView;
                {
                    this.$itemView = $itemView;
                    super(0);
                }

                public final View invoke() {
                    return this.$itemView.findViewById(R.id.ucCookieCardTitleDivider);
                }
            }));
            this.ucCardContent$delegate = LazyKt.lazy((Function0)((Function0)new Function0<UCTextView>(itemView){
                final /* synthetic */ View $itemView;
                {
                    this.$itemView = $itemView;
                    super(0);
                }

                public final UCTextView invoke() {
                    return (UCTextView)this.$itemView.findViewById(R.id.ucCardContent);
                }
            }));
            UCTextView.styleSmall$default(this.getUcCookieCardTitle(), theme, false, false, false, false, 30, null);
            UCTextView.styleSmall$default(this.getUcCardContent(), theme, false, false, false, false, 30, null);
            Integer n = theme.getColorPalette().getLayerBackgroundColor();
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                this.getUcCookieCardTitle().setBackgroundColor(it);
            }
            GradientDrawable gradientDrawable2 = gradientDrawable = new GradientDrawable();
            View view = itemView;
            boolean bl = false;
            $this$_init__u24lambda_u241.setShape(0);
            Integer n2 = theme.getColorPalette().getLayerBackgroundColor();
            $this$_init__u24lambda_u241.setColor(n2 != null ? n2 : -1);
            Context context = itemView.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            $this$_init__u24lambda_u241.setStroke(NumberExtensionsKt.dpToPx(1, context), theme.getColorPalette().getTabsBorderColor());
            view.setBackground((Drawable)gradientDrawable);
            this.getUcCookieCardTitleDivider().setBackgroundColor(theme.getColorPalette().getTabsBorderColor());
        }

        private final UCTextView getUcCookieCardTitle() {
            Lazy lazy = this.ucCookieCardTitle$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (UCTextView)((Object)object);
        }

        private final View getUcCookieCardTitleDivider() {
            Lazy lazy = this.ucCookieCardTitleDivider$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (View)object;
        }

        private final UCTextView getUcCardContent() {
            Lazy lazy = this.ucCardContent$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (UCTextView)((Object)object);
        }

        public final void bindHolder(@NotNull PredefinedUIDeviceStorageContent itemData) {
            Intrinsics.checkNotNullParameter((Object)itemData, (String)"itemData");
            this.getUcCookieCardTitle().setText(itemData.getTitle());
            this.getUcCardContent().setText(CollectionsKt.joinToString$default((Iterable)itemData.getContent(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        }
    }
}

